"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/fast-equals";
exports.ids = ["vendor-chunks/fast-equals"];
exports.modules = {

/***/ "(ssr)/./node_modules/fast-equals/dist/cjs/index.cjs":
/*!*****************************************************!*\
  !*** ./node_modules/fast-equals/dist/cjs/index.cjs ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports) => {

eval("\n\nvar getOwnPropertyNames = Object.getOwnPropertyNames, getOwnPropertySymbols = Object.getOwnPropertySymbols;\nvar hasOwnProperty = Object.prototype.hasOwnProperty;\n/**\n * Combine two comparators into a single comparators.\n */\nfunction combineComparators(comparatorA, comparatorB) {\n    return function isEqual(a, b, state) {\n        return comparatorA(a, b, state) && comparatorB(a, b, state);\n    };\n}\n/**\n * Wrap the provided `areItemsEqual` method to manage the circular state, allowing\n * for circular references to be safely included in the comparison without creating\n * stack overflows.\n */\nfunction createIsCircular(areItemsEqual) {\n    return function isCircular(a, b, state) {\n        if (!a || !b || typeof a !== 'object' || typeof b !== 'object') {\n            return areItemsEqual(a, b, state);\n        }\n        var cache = state.cache;\n        var cachedA = cache.get(a);\n        var cachedB = cache.get(b);\n        if (cachedA && cachedB) {\n            return cachedA === b && cachedB === a;\n        }\n        cache.set(a, b);\n        cache.set(b, a);\n        var result = areItemsEqual(a, b, state);\n        cache.delete(a);\n        cache.delete(b);\n        return result;\n    };\n}\n/**\n * Get the properties to strictly examine, which include both own properties that are\n * not enumerable and symbol properties.\n */\nfunction getStrictProperties(object) {\n    return getOwnPropertyNames(object).concat(getOwnPropertySymbols(object));\n}\n/**\n * Whether the object contains the property passed as an own property.\n */\nvar hasOwn = Object.hasOwn ||\n    (function (object, property) {\n        return hasOwnProperty.call(object, property);\n    });\n/**\n * Whether the values passed are strictly equal or both NaN.\n */\nfunction sameValueZeroEqual(a, b) {\n    return a || b ? a === b : a === b || (a !== a && b !== b);\n}\n\nvar OWNER = '_owner';\nvar getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor, keys = Object.keys;\n/**\n * Whether the arrays are equal in value.\n */\nfunction areArraysEqual(a, b, state) {\n    var index = a.length;\n    if (b.length !== index) {\n        return false;\n    }\n    while (index-- > 0) {\n        if (!state.equals(a[index], b[index], index, index, a, b, state)) {\n            return false;\n        }\n    }\n    return true;\n}\n/**\n * Whether the dates passed are equal in value.\n */\nfunction areDatesEqual(a, b) {\n    return sameValueZeroEqual(a.getTime(), b.getTime());\n}\n/**\n * Whether the `Map`s are equal in value.\n */\nfunction areMapsEqual(a, b, state) {\n    if (a.size !== b.size) {\n        return false;\n    }\n    var matchedIndices = {};\n    var aIterable = a.entries();\n    var index = 0;\n    var aResult;\n    var bResult;\n    while ((aResult = aIterable.next())) {\n        if (aResult.done) {\n            break;\n        }\n        var bIterable = b.entries();\n        var hasMatch = false;\n        var matchIndex = 0;\n        while ((bResult = bIterable.next())) {\n            if (bResult.done) {\n                break;\n            }\n            var _a = aResult.value, aKey = _a[0], aValue = _a[1];\n            var _b = bResult.value, bKey = _b[0], bValue = _b[1];\n            if (!hasMatch &&\n                !matchedIndices[matchIndex] &&\n                (hasMatch =\n                    state.equals(aKey, bKey, index, matchIndex, a, b, state) &&\n                        state.equals(aValue, bValue, aKey, bKey, a, b, state))) {\n                matchedIndices[matchIndex] = true;\n            }\n            matchIndex++;\n        }\n        if (!hasMatch) {\n            return false;\n        }\n        index++;\n    }\n    return true;\n}\n/**\n * Whether the objects are equal in value.\n */\nfunction areObjectsEqual(a, b, state) {\n    var properties = keys(a);\n    var index = properties.length;\n    if (keys(b).length !== index) {\n        return false;\n    }\n    var property;\n    // Decrementing `while` showed faster results than either incrementing or\n    // decrementing `for` loop and than an incrementing `while` loop. Declarative\n    // methods like `some` / `every` were not used to avoid incurring the garbage\n    // cost of anonymous callbacks.\n    while (index-- > 0) {\n        property = properties[index];\n        if (property === OWNER &&\n            (a.$$typeof || b.$$typeof) &&\n            a.$$typeof !== b.$$typeof) {\n            return false;\n        }\n        if (!hasOwn(b, property) ||\n            !state.equals(a[property], b[property], property, property, a, b, state)) {\n            return false;\n        }\n    }\n    return true;\n}\n/**\n * Whether the objects are equal in value with strict property checking.\n */\nfunction areObjectsEqualStrict(a, b, state) {\n    var properties = getStrictProperties(a);\n    var index = properties.length;\n    if (getStrictProperties(b).length !== index) {\n        return false;\n    }\n    var property;\n    var descriptorA;\n    var descriptorB;\n    // Decrementing `while` showed faster results than either incrementing or\n    // decrementing `for` loop and than an incrementing `while` loop. Declarative\n    // methods like `some` / `every` were not used to avoid incurring the garbage\n    // cost of anonymous callbacks.\n    while (index-- > 0) {\n        property = properties[index];\n        if (property === OWNER &&\n            (a.$$typeof || b.$$typeof) &&\n            a.$$typeof !== b.$$typeof) {\n            return false;\n        }\n        if (!hasOwn(b, property)) {\n            return false;\n        }\n        if (!state.equals(a[property], b[property], property, property, a, b, state)) {\n            return false;\n        }\n        descriptorA = getOwnPropertyDescriptor(a, property);\n        descriptorB = getOwnPropertyDescriptor(b, property);\n        if ((descriptorA || descriptorB) &&\n            (!descriptorA ||\n                !descriptorB ||\n                descriptorA.configurable !== descriptorB.configurable ||\n                descriptorA.enumerable !== descriptorB.enumerable ||\n                descriptorA.writable !== descriptorB.writable)) {\n            return false;\n        }\n    }\n    return true;\n}\n/**\n * Whether the primitive wrappers passed are equal in value.\n */\nfunction arePrimitiveWrappersEqual(a, b) {\n    return sameValueZeroEqual(a.valueOf(), b.valueOf());\n}\n/**\n * Whether the regexps passed are equal in value.\n */\nfunction areRegExpsEqual(a, b) {\n    return a.source === b.source && a.flags === b.flags;\n}\n/**\n * Whether the `Set`s are equal in value.\n */\nfunction areSetsEqual(a, b, state) {\n    if (a.size !== b.size) {\n        return false;\n    }\n    var matchedIndices = {};\n    var aIterable = a.values();\n    var aResult;\n    var bResult;\n    while ((aResult = aIterable.next())) {\n        if (aResult.done) {\n            break;\n        }\n        var bIterable = b.values();\n        var hasMatch = false;\n        var matchIndex = 0;\n        while ((bResult = bIterable.next())) {\n            if (bResult.done) {\n                break;\n            }\n            if (!hasMatch &&\n                !matchedIndices[matchIndex] &&\n                (hasMatch = state.equals(aResult.value, bResult.value, aResult.value, bResult.value, a, b, state))) {\n                matchedIndices[matchIndex] = true;\n            }\n            matchIndex++;\n        }\n        if (!hasMatch) {\n            return false;\n        }\n    }\n    return true;\n}\n/**\n * Whether the TypedArray instances are equal in value.\n */\nfunction areTypedArraysEqual(a, b) {\n    var index = a.length;\n    if (b.length !== index) {\n        return false;\n    }\n    while (index-- > 0) {\n        if (a[index] !== b[index]) {\n            return false;\n        }\n    }\n    return true;\n}\n\nvar ARGUMENTS_TAG = '[object Arguments]';\nvar BOOLEAN_TAG = '[object Boolean]';\nvar DATE_TAG = '[object Date]';\nvar MAP_TAG = '[object Map]';\nvar NUMBER_TAG = '[object Number]';\nvar OBJECT_TAG = '[object Object]';\nvar REG_EXP_TAG = '[object RegExp]';\nvar SET_TAG = '[object Set]';\nvar STRING_TAG = '[object String]';\nvar isArray = Array.isArray;\nvar isTypedArray = typeof ArrayBuffer === 'function' && ArrayBuffer.isView\n    ? ArrayBuffer.isView\n    : null;\nvar assign = Object.assign;\nvar getTag = Object.prototype.toString.call.bind(Object.prototype.toString);\n/**\n * Create a comparator method based on the type-specific equality comparators passed.\n */\nfunction createEqualityComparator(_a) {\n    var areArraysEqual = _a.areArraysEqual, areDatesEqual = _a.areDatesEqual, areMapsEqual = _a.areMapsEqual, areObjectsEqual = _a.areObjectsEqual, arePrimitiveWrappersEqual = _a.arePrimitiveWrappersEqual, areRegExpsEqual = _a.areRegExpsEqual, areSetsEqual = _a.areSetsEqual, areTypedArraysEqual = _a.areTypedArraysEqual;\n    /**\n     * compare the value of the two objects and return true if they are equivalent in values\n     */\n    return function comparator(a, b, state) {\n        // If the items are strictly equal, no need to do a value comparison.\n        if (a === b) {\n            return true;\n        }\n        // If the items are not non-nullish objects, then the only possibility\n        // of them being equal but not strictly is if they are both `NaN`. Since\n        // `NaN` is uniquely not equal to itself, we can use self-comparison of\n        // both objects, which is faster than `isNaN()`.\n        if (a == null ||\n            b == null ||\n            typeof a !== 'object' ||\n            typeof b !== 'object') {\n            return a !== a && b !== b;\n        }\n        var constructor = a.constructor;\n        // Checks are listed in order of commonality of use-case:\n        //   1. Common complex object types (plain object, array)\n        //   2. Common data values (date, regexp)\n        //   3. Less-common complex object types (map, set)\n        //   4. Less-common data values (promise, primitive wrappers)\n        // Inherently this is both subjective and assumptive, however\n        // when reviewing comparable libraries in the wild this order\n        // appears to be generally consistent.\n        // Constructors should match, otherwise there is potential for false positives\n        // between class and subclass or custom object and POJO.\n        if (constructor !== b.constructor) {\n            return false;\n        }\n        // `isPlainObject` only checks against the object's own realm. Cross-realm\n        // comparisons are rare, and will be handled in the ultimate fallback, so\n        // we can avoid capturing the string tag.\n        if (constructor === Object) {\n            return areObjectsEqual(a, b, state);\n        }\n        // `isArray()` works on subclasses and is cross-realm, so we can avoid capturing\n        // the string tag or doing an `instanceof` check.\n        if (isArray(a)) {\n            return areArraysEqual(a, b, state);\n        }\n        // `isTypedArray()` works on all possible TypedArray classes, so we can avoid\n        // capturing the string tag or comparing against all possible constructors.\n        if (isTypedArray != null && isTypedArray(a)) {\n            return areTypedArraysEqual(a, b, state);\n        }\n        // Try to fast-path equality checks for other complex object types in the\n        // same realm to avoid capturing the string tag. Strict equality is used\n        // instead of `instanceof` because it is more performant for the common\n        // use-case. If someone is subclassing a native class, it will be handled\n        // with the string tag comparison.\n        if (constructor === Date) {\n            return areDatesEqual(a, b, state);\n        }\n        if (constructor === RegExp) {\n            return areRegExpsEqual(a, b, state);\n        }\n        if (constructor === Map) {\n            return areMapsEqual(a, b, state);\n        }\n        if (constructor === Set) {\n            return areSetsEqual(a, b, state);\n        }\n        // Since this is a custom object, capture the string tag to determing its type.\n        // This is reasonably performant in modern environments like v8 and SpiderMonkey.\n        var tag = getTag(a);\n        if (tag === DATE_TAG) {\n            return areDatesEqual(a, b, state);\n        }\n        if (tag === REG_EXP_TAG) {\n            return areRegExpsEqual(a, b, state);\n        }\n        if (tag === MAP_TAG) {\n            return areMapsEqual(a, b, state);\n        }\n        if (tag === SET_TAG) {\n            return areSetsEqual(a, b, state);\n        }\n        if (tag === OBJECT_TAG) {\n            // The exception for value comparison is custom `Promise`-like class instances. These should\n            // be treated the same as standard `Promise` objects, which means strict equality, and if\n            // it reaches this point then that strict equality comparison has already failed.\n            return (typeof a.then !== 'function' &&\n                typeof b.then !== 'function' &&\n                areObjectsEqual(a, b, state));\n        }\n        // If an arguments tag, it should be treated as a standard object.\n        if (tag === ARGUMENTS_TAG) {\n            return areObjectsEqual(a, b, state);\n        }\n        // As the penultimate fallback, check if the values passed are primitive wrappers. This\n        // is very rare in modern JS, which is why it is deprioritized compared to all other object\n        // types.\n        if (tag === BOOLEAN_TAG || tag === NUMBER_TAG || tag === STRING_TAG) {\n            return arePrimitiveWrappersEqual(a, b, state);\n        }\n        // If not matching any tags that require a specific type of comparison, then we hard-code false because\n        // the only thing remaining is strict equality, which has already been compared. This is for a few reasons:\n        //   - Certain types that cannot be introspected (e.g., `WeakMap`). For these types, this is the only\n        //     comparison that can be made.\n        //   - For types that can be introspected, but rarely have requirements to be compared\n        //     (`ArrayBuffer`, `DataView`, etc.), the cost is avoided to prioritize the common\n        //     use-cases (may be included in a future release, if requested enough).\n        //   - For types that can be introspected but do not have an objective definition of what\n        //     equality is (`Error`, etc.), the subjective decision is to be conservative and strictly compare.\n        // In all cases, these decisions should be reevaluated based on changes to the language and\n        // common development practices.\n        return false;\n    };\n}\n/**\n * Create the configuration object used for building comparators.\n */\nfunction createEqualityComparatorConfig(_a) {\n    var circular = _a.circular, createCustomConfig = _a.createCustomConfig, strict = _a.strict;\n    var config = {\n        areArraysEqual: strict\n            ? areObjectsEqualStrict\n            : areArraysEqual,\n        areDatesEqual: areDatesEqual,\n        areMapsEqual: strict\n            ? combineComparators(areMapsEqual, areObjectsEqualStrict)\n            : areMapsEqual,\n        areObjectsEqual: strict\n            ? areObjectsEqualStrict\n            : areObjectsEqual,\n        arePrimitiveWrappersEqual: arePrimitiveWrappersEqual,\n        areRegExpsEqual: areRegExpsEqual,\n        areSetsEqual: strict\n            ? combineComparators(areSetsEqual, areObjectsEqualStrict)\n            : areSetsEqual,\n        areTypedArraysEqual: strict\n            ? areObjectsEqualStrict\n            : areTypedArraysEqual,\n    };\n    if (createCustomConfig) {\n        config = assign({}, config, createCustomConfig(config));\n    }\n    if (circular) {\n        var areArraysEqual$1 = createIsCircular(config.areArraysEqual);\n        var areMapsEqual$1 = createIsCircular(config.areMapsEqual);\n        var areObjectsEqual$1 = createIsCircular(config.areObjectsEqual);\n        var areSetsEqual$1 = createIsCircular(config.areSetsEqual);\n        config = assign({}, config, {\n            areArraysEqual: areArraysEqual$1,\n            areMapsEqual: areMapsEqual$1,\n            areObjectsEqual: areObjectsEqual$1,\n            areSetsEqual: areSetsEqual$1,\n        });\n    }\n    return config;\n}\n/**\n * Default equality comparator pass-through, used as the standard `isEqual` creator for\n * use inside the built comparator.\n */\nfunction createInternalEqualityComparator(compare) {\n    return function (a, b, _indexOrKeyA, _indexOrKeyB, _parentA, _parentB, state) {\n        return compare(a, b, state);\n    };\n}\n/**\n * Create the `isEqual` function used by the consuming application.\n */\nfunction createIsEqual(_a) {\n    var circular = _a.circular, comparator = _a.comparator, createState = _a.createState, equals = _a.equals, strict = _a.strict;\n    if (createState) {\n        return function isEqual(a, b) {\n            var _a = createState(), _b = _a.cache, cache = _b === void 0 ? circular ? new WeakMap() : undefined : _b, meta = _a.meta;\n            return comparator(a, b, {\n                cache: cache,\n                equals: equals,\n                meta: meta,\n                strict: strict,\n            });\n        };\n    }\n    if (circular) {\n        return function isEqual(a, b) {\n            return comparator(a, b, {\n                cache: new WeakMap(),\n                equals: equals,\n                meta: undefined,\n                strict: strict,\n            });\n        };\n    }\n    var state = {\n        cache: undefined,\n        equals: equals,\n        meta: undefined,\n        strict: strict,\n    };\n    return function isEqual(a, b) {\n        return comparator(a, b, state);\n    };\n}\n\n/**\n * Whether the items passed are deeply-equal in value.\n */\nvar deepEqual = createCustomEqual();\n/**\n * Whether the items passed are deeply-equal in value based on strict comparison.\n */\nvar strictDeepEqual = createCustomEqual({ strict: true });\n/**\n * Whether the items passed are deeply-equal in value, including circular references.\n */\nvar circularDeepEqual = createCustomEqual({ circular: true });\n/**\n * Whether the items passed are deeply-equal in value, including circular references,\n * based on strict comparison.\n */\nvar strictCircularDeepEqual = createCustomEqual({\n    circular: true,\n    strict: true,\n});\n/**\n * Whether the items passed are shallowly-equal in value.\n */\nvar shallowEqual = createCustomEqual({\n    createInternalComparator: function () { return sameValueZeroEqual; },\n});\n/**\n * Whether the items passed are shallowly-equal in value based on strict comparison\n */\nvar strictShallowEqual = createCustomEqual({\n    strict: true,\n    createInternalComparator: function () { return sameValueZeroEqual; },\n});\n/**\n * Whether the items passed are shallowly-equal in value, including circular references.\n */\nvar circularShallowEqual = createCustomEqual({\n    circular: true,\n    createInternalComparator: function () { return sameValueZeroEqual; },\n});\n/**\n * Whether the items passed are shallowly-equal in value, including circular references,\n * based on strict comparison.\n */\nvar strictCircularShallowEqual = createCustomEqual({\n    circular: true,\n    createInternalComparator: function () { return sameValueZeroEqual; },\n    strict: true,\n});\n/**\n * Create a custom equality comparison method.\n *\n * This can be done to create very targeted comparisons in extreme hot-path scenarios\n * where the standard methods are not performant enough, but can also be used to provide\n * support for legacy environments that do not support expected features like\n * `RegExp.prototype.flags` out of the box.\n */\nfunction createCustomEqual(options) {\n    if (options === void 0) { options = {}; }\n    var _a = options.circular, circular = _a === void 0 ? false : _a, createCustomInternalComparator = options.createInternalComparator, createState = options.createState, _b = options.strict, strict = _b === void 0 ? false : _b;\n    var config = createEqualityComparatorConfig(options);\n    var comparator = createEqualityComparator(config);\n    var equals = createCustomInternalComparator\n        ? createCustomInternalComparator(comparator)\n        : createInternalEqualityComparator(comparator);\n    return createIsEqual({ circular: circular, comparator: comparator, createState: createState, equals: equals, strict: strict });\n}\n\nexports.circularDeepEqual = circularDeepEqual;\nexports.circularShallowEqual = circularShallowEqual;\nexports.createCustomEqual = createCustomEqual;\nexports.deepEqual = deepEqual;\nexports.sameValueZeroEqual = sameValueZeroEqual;\nexports.shallowEqual = shallowEqual;\nexports.strictCircularDeepEqual = strictCircularDeepEqual;\nexports.strictCircularShallowEqual = strictCircularShallowEqual;\nexports.strictDeepEqual = strictDeepEqual;\nexports.strictShallowEqual = strictShallowEqual;\n//# sourceMappingURL=index.cjs.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/fast-equals/dist/cjs/index.cjs\n");

/***/ })

};
;