"use strict";
/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
exports.id = "vendor-chunks/react-day-picker";
exports.ids = ["vendor-chunks/react-day-picker"];
exports.modules = {

/***/ "(ssr)/./node_modules/react-day-picker/dist/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/react-day-picker/dist/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("\n\nvar jsxRuntime = __webpack_require__(/*! react/jsx-runtime */ \"(ssr)/./node_modules/next/dist/server/future/route-modules/app-page/vendored/shared/react-jsx-runtime.js\");\nvar react = __webpack_require__(/*! react */ \"(ssr)/./node_modules/next/dist/server/future/route-modules/app-page/vendored/ssr/react.js\");\nvar dateFns = __webpack_require__(/*! date-fns */ \"(ssr)/./node_modules/date-fns/index.js\");\nvar locale = __webpack_require__(/*! date-fns/locale */ \"(ssr)/./node_modules/date-fns/locale.js\");\n\n/******************************************************************************\r\nCopyright (c) Microsoft Corporation.\r\n\r\nPermission to use, copy, modify, and/or distribute this software for any\r\npurpose with or without fee is hereby granted.\r\n\r\nTHE SOFTWARE IS PROVIDED \"AS IS\" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH\r\nREGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY\r\nAND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,\r\nINDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM\r\nLOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR\r\nOTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR\r\nPERFORMANCE OF THIS SOFTWARE.\r\n***************************************************************************** */\r\n/* global Reflect, Promise, SuppressedError, Symbol */\r\n\r\n\r\nvar __assign = function() {\r\n    __assign = Object.assign || function __assign(t) {\r\n        for (var s, i = 1, n = arguments.length; i < n; i++) {\r\n            s = arguments[i];\r\n            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];\r\n        }\r\n        return t;\r\n    };\r\n    return __assign.apply(this, arguments);\r\n};\r\n\r\nfunction __rest(s, e) {\r\n    var t = {};\r\n    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)\r\n        t[p] = s[p];\r\n    if (s != null && typeof Object.getOwnPropertySymbols === \"function\")\r\n        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {\r\n            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))\r\n                t[p[i]] = s[p[i]];\r\n        }\r\n    return t;\r\n}\r\n\r\nfunction __spreadArray(to, from, pack) {\r\n    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {\r\n        if (ar || !(i in from)) {\r\n            if (!ar) ar = Array.prototype.slice.call(from, 0, i);\r\n            ar[i] = from[i];\r\n        }\r\n    }\r\n    return to.concat(ar || Array.prototype.slice.call(from));\r\n}\r\n\r\ntypeof SuppressedError === \"function\" ? SuppressedError : function (error, suppressed, message) {\r\n    var e = new Error(message);\r\n    return e.name = \"SuppressedError\", e.error = error, e.suppressed = suppressed, e;\r\n};\n\n/** Returns true when the props are of type {@link DayPickerMultipleProps}. */\nfunction isDayPickerMultiple(props) {\n    return props.mode === 'multiple';\n}\n\n/** Returns true when the props are of type {@link DayPickerRangeProps}. */\nfunction isDayPickerRange(props) {\n    return props.mode === 'range';\n}\n\n/** Returns true when the props are of type {@link DayPickerSingleProps}. */\nfunction isDayPickerSingle(props) {\n    return props.mode === 'single';\n}\n\n/**\n * The name of the default CSS classes.\n */\nvar defaultClassNames = {\n    root: 'rdp',\n    multiple_months: 'rdp-multiple_months',\n    with_weeknumber: 'rdp-with_weeknumber',\n    vhidden: 'rdp-vhidden',\n    button_reset: 'rdp-button_reset',\n    button: 'rdp-button',\n    caption: 'rdp-caption',\n    caption_start: 'rdp-caption_start',\n    caption_end: 'rdp-caption_end',\n    caption_between: 'rdp-caption_between',\n    caption_label: 'rdp-caption_label',\n    caption_dropdowns: 'rdp-caption_dropdowns',\n    dropdown: 'rdp-dropdown',\n    dropdown_month: 'rdp-dropdown_month',\n    dropdown_year: 'rdp-dropdown_year',\n    dropdown_icon: 'rdp-dropdown_icon',\n    months: 'rdp-months',\n    month: 'rdp-month',\n    table: 'rdp-table',\n    tbody: 'rdp-tbody',\n    tfoot: 'rdp-tfoot',\n    head: 'rdp-head',\n    head_row: 'rdp-head_row',\n    head_cell: 'rdp-head_cell',\n    nav: 'rdp-nav',\n    nav_button: 'rdp-nav_button',\n    nav_button_previous: 'rdp-nav_button_previous',\n    nav_button_next: 'rdp-nav_button_next',\n    nav_icon: 'rdp-nav_icon',\n    row: 'rdp-row',\n    weeknumber: 'rdp-weeknumber',\n    cell: 'rdp-cell',\n    day: 'rdp-day',\n    day_today: 'rdp-day_today',\n    day_outside: 'rdp-day_outside',\n    day_selected: 'rdp-day_selected',\n    day_disabled: 'rdp-day_disabled',\n    day_hidden: 'rdp-day_hidden',\n    day_range_start: 'rdp-day_range_start',\n    day_range_end: 'rdp-day_range_end',\n    day_range_middle: 'rdp-day_range_middle'\n};\n\n/**\n * The default formatter for the caption.\n */\nfunction formatCaption(month, options) {\n    return dateFns.format(month, 'LLLL y', options);\n}\n\n/**\n * The default formatter for the Day button.\n */\nfunction formatDay(day, options) {\n    return dateFns.format(day, 'd', options);\n}\n\n/**\n * The default formatter for the Month caption.\n */\nfunction formatMonthCaption(month, options) {\n    return dateFns.format(month, 'LLLL', options);\n}\n\n/**\n * The default formatter for the week number.\n */\nfunction formatWeekNumber(weekNumber) {\n    return \"\".concat(weekNumber);\n}\n\n/**\n * The default formatter for the name of the weekday.\n */\nfunction formatWeekdayName(weekday, options) {\n    return dateFns.format(weekday, 'cccccc', options);\n}\n\n/**\n * The default formatter for the Year caption.\n */\nfunction formatYearCaption(year, options) {\n    return dateFns.format(year, 'yyyy', options);\n}\n\nvar formatters = /*#__PURE__*/Object.freeze({\n    __proto__: null,\n    formatCaption: formatCaption,\n    formatDay: formatDay,\n    formatMonthCaption: formatMonthCaption,\n    formatWeekNumber: formatWeekNumber,\n    formatWeekdayName: formatWeekdayName,\n    formatYearCaption: formatYearCaption\n});\n\n/**\n * The default ARIA label for the day button.\n */\nvar labelDay = function (day, activeModifiers, options) {\n    return dateFns.format(day, 'do MMMM (EEEE)', options);\n};\n\n/**\n * The default ARIA label for the WeekNumber element.\n */\nvar labelMonthDropdown = function () {\n    return 'Month: ';\n};\n\n/**\n * The default ARIA label for next month button in navigation\n */\nvar labelNext = function () {\n    return 'Go to next month';\n};\n\n/**\n * The default ARIA label for previous month button in navigation\n */\nvar labelPrevious = function () {\n    return 'Go to previous month';\n};\n\n/**\n * The default ARIA label for the Weekday element.\n */\nvar labelWeekday = function (day, options) {\n    return dateFns.format(day, 'cccc', options);\n};\n\n/**\n * The default ARIA label for the WeekNumber element.\n */\nvar labelWeekNumber = function (n) {\n    return \"Week n. \".concat(n);\n};\n\n/**\n * The default ARIA label for the WeekNumber element.\n */\nvar labelYearDropdown = function () {\n    return 'Year: ';\n};\n\nvar labels = /*#__PURE__*/Object.freeze({\n    __proto__: null,\n    labelDay: labelDay,\n    labelMonthDropdown: labelMonthDropdown,\n    labelNext: labelNext,\n    labelPrevious: labelPrevious,\n    labelWeekNumber: labelWeekNumber,\n    labelWeekday: labelWeekday,\n    labelYearDropdown: labelYearDropdown\n});\n\n/**\n * Returns the default values to use in the DayPickerContext, in case they are\n * not passed down with the DayPicker initial props.\n */\nfunction getDefaultContextValues() {\n    var captionLayout = 'buttons';\n    var classNames = defaultClassNames;\n    var locale$1 = locale.enUS;\n    var modifiersClassNames = {};\n    var modifiers = {};\n    var numberOfMonths = 1;\n    var styles = {};\n    var today = new Date();\n    return {\n        captionLayout: captionLayout,\n        classNames: classNames,\n        formatters: formatters,\n        labels: labels,\n        locale: locale$1,\n        modifiersClassNames: modifiersClassNames,\n        modifiers: modifiers,\n        numberOfMonths: numberOfMonths,\n        styles: styles,\n        today: today,\n        mode: 'default'\n    };\n}\n\n/** Return the `fromDate` and `toDate` prop values values parsing the DayPicker props. */\nfunction parseFromToProps(props) {\n    var fromYear = props.fromYear, toYear = props.toYear, fromMonth = props.fromMonth, toMonth = props.toMonth;\n    var fromDate = props.fromDate, toDate = props.toDate;\n    if (fromMonth) {\n        fromDate = dateFns.startOfMonth(fromMonth);\n    }\n    else if (fromYear) {\n        fromDate = new Date(fromYear, 0, 1);\n    }\n    if (toMonth) {\n        toDate = dateFns.endOfMonth(toMonth);\n    }\n    else if (toYear) {\n        toDate = new Date(toYear, 11, 31);\n    }\n    return {\n        fromDate: fromDate ? dateFns.startOfDay(fromDate) : undefined,\n        toDate: toDate ? dateFns.startOfDay(toDate) : undefined\n    };\n}\n\n/**\n * The DayPicker context shares the props passed to DayPicker within internal\n * and custom components. It is used to set the default values and perform\n * one-time calculations required to render the days.\n *\n * Access to this context from the {@link useDayPicker} hook.\n */\nvar DayPickerContext = react.createContext(undefined);\n/**\n * The provider for the {@link DayPickerContext}, assigning the defaults from the\n * initial DayPicker props.\n */\nfunction DayPickerProvider(props) {\n    var _a;\n    var initialProps = props.initialProps;\n    var defaultContextValues = getDefaultContextValues();\n    var _b = parseFromToProps(initialProps), fromDate = _b.fromDate, toDate = _b.toDate;\n    var captionLayout = (_a = initialProps.captionLayout) !== null && _a !== void 0 ? _a : defaultContextValues.captionLayout;\n    if (captionLayout !== 'buttons' && (!fromDate || !toDate)) {\n        // When no from/to dates are set, the caption is always buttons\n        captionLayout = 'buttons';\n    }\n    var onSelect;\n    if (isDayPickerSingle(initialProps) ||\n        isDayPickerMultiple(initialProps) ||\n        isDayPickerRange(initialProps)) {\n        onSelect = initialProps.onSelect;\n    }\n    var value = __assign(__assign(__assign({}, defaultContextValues), initialProps), { captionLayout: captionLayout, classNames: __assign(__assign({}, defaultContextValues.classNames), initialProps.classNames), components: __assign({}, initialProps.components), formatters: __assign(__assign({}, defaultContextValues.formatters), initialProps.formatters), fromDate: fromDate, labels: __assign(__assign({}, defaultContextValues.labels), initialProps.labels), mode: initialProps.mode || defaultContextValues.mode, modifiers: __assign(__assign({}, defaultContextValues.modifiers), initialProps.modifiers), modifiersClassNames: __assign(__assign({}, defaultContextValues.modifiersClassNames), initialProps.modifiersClassNames), onSelect: onSelect, styles: __assign(__assign({}, defaultContextValues.styles), initialProps.styles), toDate: toDate });\n    return (jsxRuntime.jsx(DayPickerContext.Provider, { value: value, children: props.children }));\n}\n/**\n * Hook to access the {@link DayPickerContextValue}.\n *\n * Use the DayPicker context to access to the props passed to DayPicker inside\n * internal or custom components.\n */\nfunction useDayPicker() {\n    var context = react.useContext(DayPickerContext);\n    if (!context) {\n        throw new Error(\"useDayPicker must be used within a DayPickerProvider.\");\n    }\n    return context;\n}\n\n/** Render the caption for the displayed month. This component is used when `captionLayout=\"buttons\"`. */\nfunction CaptionLabel(props) {\n    var _a = useDayPicker(), locale = _a.locale, classNames = _a.classNames, styles = _a.styles, formatCaption = _a.formatters.formatCaption;\n    return (jsxRuntime.jsx(\"div\", { className: classNames.caption_label, style: styles.caption_label, \"aria-live\": \"polite\", role: \"presentation\", id: props.id, children: formatCaption(props.displayMonth, { locale: locale }) }));\n}\n\n/**\n * Render the icon in the styled drop-down.\n */\nfunction IconDropdown(props) {\n    return (jsxRuntime.jsx(\"svg\", __assign({ width: \"8px\", height: \"8px\", viewBox: \"0 0 120 120\", \"data-testid\": \"iconDropdown\" }, props, { children: jsxRuntime.jsx(\"path\", { d: \"M4.22182541,48.2218254 C8.44222828,44.0014225 15.2388494,43.9273804 19.5496459,47.9996989 L19.7781746,48.2218254 L60,88.443 L100.221825,48.2218254 C104.442228,44.0014225 111.238849,43.9273804 115.549646,47.9996989 L115.778175,48.2218254 C119.998577,52.4422283 120.07262,59.2388494 116.000301,63.5496459 L115.778175,63.7781746 L67.7781746,111.778175 C63.5577717,115.998577 56.7611506,116.07262 52.4503541,112.000301 L52.2218254,111.778175 L4.22182541,63.7781746 C-0.0739418023,59.4824074 -0.0739418023,52.5175926 4.22182541,48.2218254 Z\", fill: \"currentColor\", fillRule: \"nonzero\" }) })));\n}\n\n/**\n * Render a styled select component – displaying a caption and a custom\n * drop-down icon.\n */\nfunction Dropdown(props) {\n    var _a, _b;\n    var onChange = props.onChange, value = props.value, children = props.children, caption = props.caption, className = props.className, style = props.style;\n    var dayPicker = useDayPicker();\n    var IconDropdownComponent = (_b = (_a = dayPicker.components) === null || _a === void 0 ? void 0 : _a.IconDropdown) !== null && _b !== void 0 ? _b : IconDropdown;\n    return (jsxRuntime.jsxs(\"div\", { className: className, style: style, children: [jsxRuntime.jsx(\"span\", { className: dayPicker.classNames.vhidden, children: props['aria-label'] }), jsxRuntime.jsx(\"select\", { name: props.name, \"aria-label\": props['aria-label'], className: dayPicker.classNames.dropdown, style: dayPicker.styles.dropdown, value: value, onChange: onChange, children: children }), jsxRuntime.jsxs(\"div\", { className: dayPicker.classNames.caption_label, style: dayPicker.styles.caption_label, \"aria-hidden\": \"true\", children: [caption, jsxRuntime.jsx(IconDropdownComponent, { className: dayPicker.classNames.dropdown_icon, style: dayPicker.styles.dropdown_icon })] })] }));\n}\n\n/** Render the dropdown to navigate between months. */\nfunction MonthsDropdown(props) {\n    var _a;\n    var _b = useDayPicker(), fromDate = _b.fromDate, toDate = _b.toDate, styles = _b.styles, locale = _b.locale, formatMonthCaption = _b.formatters.formatMonthCaption, classNames = _b.classNames, components = _b.components, labelMonthDropdown = _b.labels.labelMonthDropdown;\n    // Dropdown should appear only when both from/toDate is set\n    if (!fromDate)\n        return jsxRuntime.jsx(jsxRuntime.Fragment, {});\n    if (!toDate)\n        return jsxRuntime.jsx(jsxRuntime.Fragment, {});\n    var dropdownMonths = [];\n    if (dateFns.isSameYear(fromDate, toDate)) {\n        // only display the months included in the range\n        var date = dateFns.startOfMonth(fromDate);\n        for (var month = fromDate.getMonth(); month <= toDate.getMonth(); month++) {\n            dropdownMonths.push(dateFns.setMonth(date, month));\n        }\n    }\n    else {\n        // display all the 12 months\n        var date = dateFns.startOfMonth(new Date()); // Any date should be OK, as we just need the year\n        for (var month = 0; month <= 11; month++) {\n            dropdownMonths.push(dateFns.setMonth(date, month));\n        }\n    }\n    var handleChange = function (e) {\n        var selectedMonth = Number(e.target.value);\n        var newMonth = dateFns.setMonth(dateFns.startOfMonth(props.displayMonth), selectedMonth);\n        props.onChange(newMonth);\n    };\n    var DropdownComponent = (_a = components === null || components === void 0 ? void 0 : components.Dropdown) !== null && _a !== void 0 ? _a : Dropdown;\n    return (jsxRuntime.jsx(DropdownComponent, { name: \"months\", \"aria-label\": labelMonthDropdown(), className: classNames.dropdown_month, style: styles.dropdown_month, onChange: handleChange, value: props.displayMonth.getMonth(), caption: formatMonthCaption(props.displayMonth, { locale: locale }), children: dropdownMonths.map(function (m) { return (jsxRuntime.jsx(\"option\", { value: m.getMonth(), children: formatMonthCaption(m, { locale: locale }) }, m.getMonth())); }) }));\n}\n\n/**\n * Render a dropdown to change the year. Take in account the `nav.fromDate` and\n * `toDate` from context.\n */\nfunction YearsDropdown(props) {\n    var _a;\n    var displayMonth = props.displayMonth;\n    var _b = useDayPicker(), fromDate = _b.fromDate, toDate = _b.toDate, locale = _b.locale, styles = _b.styles, classNames = _b.classNames, components = _b.components, formatYearCaption = _b.formatters.formatYearCaption, labelYearDropdown = _b.labels.labelYearDropdown;\n    var years = [];\n    // Dropdown should appear only when both from/toDate is set\n    if (!fromDate)\n        return jsxRuntime.jsx(jsxRuntime.Fragment, {});\n    if (!toDate)\n        return jsxRuntime.jsx(jsxRuntime.Fragment, {});\n    var fromYear = fromDate.getFullYear();\n    var toYear = toDate.getFullYear();\n    for (var year = fromYear; year <= toYear; year++) {\n        years.push(dateFns.setYear(dateFns.startOfYear(new Date()), year));\n    }\n    var handleChange = function (e) {\n        var newMonth = dateFns.setYear(dateFns.startOfMonth(displayMonth), Number(e.target.value));\n        props.onChange(newMonth);\n    };\n    var DropdownComponent = (_a = components === null || components === void 0 ? void 0 : components.Dropdown) !== null && _a !== void 0 ? _a : Dropdown;\n    return (jsxRuntime.jsx(DropdownComponent, { name: \"years\", \"aria-label\": labelYearDropdown(), className: classNames.dropdown_year, style: styles.dropdown_year, onChange: handleChange, value: displayMonth.getFullYear(), caption: formatYearCaption(displayMonth, { locale: locale }), children: years.map(function (year) { return (jsxRuntime.jsx(\"option\", { value: year.getFullYear(), children: formatYearCaption(year, { locale: locale }) }, year.getFullYear())); }) }));\n}\n\n/**\n * Helper hook for using controlled/uncontrolled values from a component props.\n *\n * When the value is not controlled, pass `undefined` as `controlledValue` and\n * use the returned setter to update it.\n *\n * When the value is controlled, pass the controlled value as second\n * argument, which will be always returned as `value`.\n */\nfunction useControlledValue(defaultValue, controlledValue) {\n    var _a = react.useState(defaultValue), uncontrolledValue = _a[0], setValue = _a[1];\n    var value = controlledValue === undefined ? uncontrolledValue : controlledValue;\n    return [value, setValue];\n}\n\n/** Return the initial month according to the given options. */\nfunction getInitialMonth(context) {\n    var month = context.month, defaultMonth = context.defaultMonth, today = context.today;\n    var initialMonth = month || defaultMonth || today || new Date();\n    var toDate = context.toDate, fromDate = context.fromDate, _a = context.numberOfMonths, numberOfMonths = _a === void 0 ? 1 : _a;\n    // Fix the initialMonth if is after the to-date\n    if (toDate && dateFns.differenceInCalendarMonths(toDate, initialMonth) < 0) {\n        var offset = -1 * (numberOfMonths - 1);\n        initialMonth = dateFns.addMonths(toDate, offset);\n    }\n    // Fix the initialMonth if is before the from-date\n    if (fromDate && dateFns.differenceInCalendarMonths(initialMonth, fromDate) < 0) {\n        initialMonth = fromDate;\n    }\n    return dateFns.startOfMonth(initialMonth);\n}\n\n/** Controls the navigation state. */\nfunction useNavigationState() {\n    var context = useDayPicker();\n    var initialMonth = getInitialMonth(context);\n    var _a = useControlledValue(initialMonth, context.month), month = _a[0], setMonth = _a[1];\n    var goToMonth = function (date) {\n        var _a;\n        if (context.disableNavigation)\n            return;\n        var month = dateFns.startOfMonth(date);\n        setMonth(month);\n        (_a = context.onMonthChange) === null || _a === void 0 ? void 0 : _a.call(context, month);\n    };\n    return [month, goToMonth];\n}\n\n/**\n * Return the months to display in the component according to the number of\n * months and the from/to date.\n */\nfunction getDisplayMonths(month, _a) {\n    var reverseMonths = _a.reverseMonths, numberOfMonths = _a.numberOfMonths;\n    var start = dateFns.startOfMonth(month);\n    var end = dateFns.startOfMonth(dateFns.addMonths(start, numberOfMonths));\n    var monthsDiff = dateFns.differenceInCalendarMonths(end, start);\n    var months = [];\n    for (var i = 0; i < monthsDiff; i++) {\n        var nextMonth = dateFns.addMonths(start, i);\n        months.push(nextMonth);\n    }\n    if (reverseMonths)\n        months = months.reverse();\n    return months;\n}\n\n/**\n * Returns the next month the user can navigate to according to the given\n * options.\n *\n * Please note that the next month is not always the next calendar month:\n *\n * - if after the `toDate` range, is undefined;\n * - if the navigation is paged, is the number of months displayed ahead.\n *\n */\nfunction getNextMonth(startingMonth, options) {\n    if (options.disableNavigation) {\n        return undefined;\n    }\n    var toDate = options.toDate, pagedNavigation = options.pagedNavigation, _a = options.numberOfMonths, numberOfMonths = _a === void 0 ? 1 : _a;\n    var offset = pagedNavigation ? numberOfMonths : 1;\n    var month = dateFns.startOfMonth(startingMonth);\n    if (!toDate) {\n        return dateFns.addMonths(month, offset);\n    }\n    var monthsDiff = dateFns.differenceInCalendarMonths(toDate, startingMonth);\n    if (monthsDiff < numberOfMonths) {\n        return undefined;\n    }\n    // Jump forward as the number of months when paged navigation\n    return dateFns.addMonths(month, offset);\n}\n\n/**\n * Returns the next previous the user can navigate to, according to the given\n * options.\n *\n * Please note that the previous month is not always the previous calendar\n * month:\n *\n * - if before the `fromDate` date, is `undefined`;\n * - if the navigation is paged, is the number of months displayed before.\n *\n */\nfunction getPreviousMonth(startingMonth, options) {\n    if (options.disableNavigation) {\n        return undefined;\n    }\n    var fromDate = options.fromDate, pagedNavigation = options.pagedNavigation, _a = options.numberOfMonths, numberOfMonths = _a === void 0 ? 1 : _a;\n    var offset = pagedNavigation ? numberOfMonths : 1;\n    var month = dateFns.startOfMonth(startingMonth);\n    if (!fromDate) {\n        return dateFns.addMonths(month, -offset);\n    }\n    var monthsDiff = dateFns.differenceInCalendarMonths(month, fromDate);\n    if (monthsDiff <= 0) {\n        return undefined;\n    }\n    // Jump back as the number of months when paged navigation\n    return dateFns.addMonths(month, -offset);\n}\n\n/**\n * The Navigation context shares details and methods to navigate the months in DayPicker.\n * Access this context from the {@link useNavigation} hook.\n */\nvar NavigationContext = react.createContext(undefined);\n/** Provides the values for the {@link NavigationContext}. */\nfunction NavigationProvider(props) {\n    var dayPicker = useDayPicker();\n    var _a = useNavigationState(), currentMonth = _a[0], goToMonth = _a[1];\n    var displayMonths = getDisplayMonths(currentMonth, dayPicker);\n    var nextMonth = getNextMonth(currentMonth, dayPicker);\n    var previousMonth = getPreviousMonth(currentMonth, dayPicker);\n    var isDateDisplayed = function (date) {\n        return displayMonths.some(function (displayMonth) {\n            return dateFns.isSameMonth(date, displayMonth);\n        });\n    };\n    var goToDate = function (date, refDate) {\n        if (isDateDisplayed(date)) {\n            return;\n        }\n        if (refDate && dateFns.isBefore(date, refDate)) {\n            goToMonth(dateFns.addMonths(date, 1 + dayPicker.numberOfMonths * -1));\n        }\n        else {\n            goToMonth(date);\n        }\n    };\n    var value = {\n        currentMonth: currentMonth,\n        displayMonths: displayMonths,\n        goToMonth: goToMonth,\n        goToDate: goToDate,\n        previousMonth: previousMonth,\n        nextMonth: nextMonth,\n        isDateDisplayed: isDateDisplayed\n    };\n    return (jsxRuntime.jsx(NavigationContext.Provider, { value: value, children: props.children }));\n}\n/**\n * Hook to access the {@link NavigationContextValue}. Use this hook to navigate\n * between months or years in DayPicker.\n *\n * This hook is meant to be used inside internal or custom components.\n */\nfunction useNavigation() {\n    var context = react.useContext(NavigationContext);\n    if (!context) {\n        throw new Error('useNavigation must be used within a NavigationProvider');\n    }\n    return context;\n}\n\n/**\n * Render a caption with the dropdowns to navigate between months and years.\n */\nfunction CaptionDropdowns(props) {\n    var _a;\n    var _b = useDayPicker(), classNames = _b.classNames, styles = _b.styles, components = _b.components;\n    var goToMonth = useNavigation().goToMonth;\n    var handleMonthChange = function (newMonth) {\n        goToMonth(dateFns.addMonths(newMonth, props.displayIndex ? -props.displayIndex : 0));\n    };\n    var CaptionLabelComponent = (_a = components === null || components === void 0 ? void 0 : components.CaptionLabel) !== null && _a !== void 0 ? _a : CaptionLabel;\n    var captionLabel = (jsxRuntime.jsx(CaptionLabelComponent, { id: props.id, displayMonth: props.displayMonth }));\n    return (jsxRuntime.jsxs(\"div\", { className: classNames.caption_dropdowns, style: styles.caption_dropdowns, children: [jsxRuntime.jsx(\"div\", { className: classNames.vhidden, children: captionLabel }), jsxRuntime.jsx(MonthsDropdown, { onChange: handleMonthChange, displayMonth: props.displayMonth }), jsxRuntime.jsx(YearsDropdown, { onChange: handleMonthChange, displayMonth: props.displayMonth })] }));\n}\n\n/**\n * Render the \"previous month\" button in the navigation.\n */\nfunction IconLeft(props) {\n    return (jsxRuntime.jsx(\"svg\", __assign({ width: \"16px\", height: \"16px\", viewBox: \"0 0 120 120\" }, props, { children: jsxRuntime.jsx(\"path\", { d: \"M69.490332,3.34314575 C72.6145263,0.218951416 77.6798462,0.218951416 80.8040405,3.34314575 C83.8617626,6.40086786 83.9268205,11.3179931 80.9992143,14.4548388 L80.8040405,14.6568542 L35.461,60 L80.8040405,105.343146 C83.8617626,108.400868 83.9268205,113.317993 80.9992143,116.454839 L80.8040405,116.656854 C77.7463184,119.714576 72.8291931,119.779634 69.6923475,116.852028 L69.490332,116.656854 L18.490332,65.6568542 C15.4326099,62.5991321 15.367552,57.6820069 18.2951583,54.5451612 L18.490332,54.3431458 L69.490332,3.34314575 Z\", fill: \"currentColor\", fillRule: \"nonzero\" }) })));\n}\n\n/**\n * Render the \"next month\" button in the navigation.\n */\nfunction IconRight(props) {\n    return (jsxRuntime.jsx(\"svg\", __assign({ width: \"16px\", height: \"16px\", viewBox: \"0 0 120 120\" }, props, { children: jsxRuntime.jsx(\"path\", { d: \"M49.8040405,3.34314575 C46.6798462,0.218951416 41.6145263,0.218951416 38.490332,3.34314575 C35.4326099,6.40086786 35.367552,11.3179931 38.2951583,14.4548388 L38.490332,14.6568542 L83.8333725,60 L38.490332,105.343146 C35.4326099,108.400868 35.367552,113.317993 38.2951583,116.454839 L38.490332,116.656854 C41.5480541,119.714576 46.4651794,119.779634 49.602025,116.852028 L49.8040405,116.656854 L100.804041,65.6568542 C103.861763,62.5991321 103.926821,57.6820069 100.999214,54.5451612 L100.804041,54.3431458 L49.8040405,3.34314575 Z\", fill: \"currentColor\" }) })));\n}\n\n/** Render a button HTML element applying the reset class name. */\nvar Button = react.forwardRef(function (props, ref) {\n    var _a = useDayPicker(), classNames = _a.classNames, styles = _a.styles;\n    var classNamesArr = [classNames.button_reset, classNames.button];\n    if (props.className) {\n        classNamesArr.push(props.className);\n    }\n    var className = classNamesArr.join(' ');\n    var style = __assign(__assign({}, styles.button_reset), styles.button);\n    if (props.style) {\n        Object.assign(style, props.style);\n    }\n    return (jsxRuntime.jsx(\"button\", __assign({}, props, { ref: ref, type: \"button\", className: className, style: style })));\n});\n\n/** A component rendering the navigation buttons or the drop-downs. */\nfunction Navigation(props) {\n    var _a, _b;\n    var _c = useDayPicker(), dir = _c.dir, locale = _c.locale, classNames = _c.classNames, styles = _c.styles, _d = _c.labels, labelPrevious = _d.labelPrevious, labelNext = _d.labelNext, components = _c.components;\n    if (!props.nextMonth && !props.previousMonth) {\n        return jsxRuntime.jsx(jsxRuntime.Fragment, {});\n    }\n    var previousLabel = labelPrevious(props.previousMonth, { locale: locale });\n    var previousClassName = [\n        classNames.nav_button,\n        classNames.nav_button_previous\n    ].join(' ');\n    var nextLabel = labelNext(props.nextMonth, { locale: locale });\n    var nextClassName = [\n        classNames.nav_button,\n        classNames.nav_button_next\n    ].join(' ');\n    var IconRightComponent = (_a = components === null || components === void 0 ? void 0 : components.IconRight) !== null && _a !== void 0 ? _a : IconRight;\n    var IconLeftComponent = (_b = components === null || components === void 0 ? void 0 : components.IconLeft) !== null && _b !== void 0 ? _b : IconLeft;\n    return (jsxRuntime.jsxs(\"div\", { className: classNames.nav, style: styles.nav, children: [!props.hidePrevious && (jsxRuntime.jsx(Button, { name: \"previous-month\", \"aria-label\": previousLabel, className: previousClassName, style: styles.nav_button_previous, disabled: !props.previousMonth, onClick: props.onPreviousClick, children: dir === 'rtl' ? (jsxRuntime.jsx(IconRightComponent, { className: classNames.nav_icon, style: styles.nav_icon })) : (jsxRuntime.jsx(IconLeftComponent, { className: classNames.nav_icon, style: styles.nav_icon })) })), !props.hideNext && (jsxRuntime.jsx(Button, { name: \"next-month\", \"aria-label\": nextLabel, className: nextClassName, style: styles.nav_button_next, disabled: !props.nextMonth, onClick: props.onNextClick, children: dir === 'rtl' ? (jsxRuntime.jsx(IconLeftComponent, { className: classNames.nav_icon, style: styles.nav_icon })) : (jsxRuntime.jsx(IconRightComponent, { className: classNames.nav_icon, style: styles.nav_icon })) }))] }));\n}\n\n/**\n * Render a caption with a button-based navigation.\n */\nfunction CaptionNavigation(props) {\n    var numberOfMonths = useDayPicker().numberOfMonths;\n    var _a = useNavigation(), previousMonth = _a.previousMonth, nextMonth = _a.nextMonth, goToMonth = _a.goToMonth, displayMonths = _a.displayMonths;\n    var displayIndex = displayMonths.findIndex(function (month) {\n        return dateFns.isSameMonth(props.displayMonth, month);\n    });\n    var isFirst = displayIndex === 0;\n    var isLast = displayIndex === displayMonths.length - 1;\n    var hideNext = numberOfMonths > 1 && (isFirst || !isLast);\n    var hidePrevious = numberOfMonths > 1 && (isLast || !isFirst);\n    var handlePreviousClick = function () {\n        if (!previousMonth)\n            return;\n        goToMonth(previousMonth);\n    };\n    var handleNextClick = function () {\n        if (!nextMonth)\n            return;\n        goToMonth(nextMonth);\n    };\n    return (jsxRuntime.jsx(Navigation, { displayMonth: props.displayMonth, hideNext: hideNext, hidePrevious: hidePrevious, nextMonth: nextMonth, previousMonth: previousMonth, onPreviousClick: handlePreviousClick, onNextClick: handleNextClick }));\n}\n\n/**\n * Render the caption of a month. The caption has a different layout when\n * setting the {@link DayPickerBase.captionLayout} prop.\n */\nfunction Caption(props) {\n    var _a;\n    var _b = useDayPicker(), classNames = _b.classNames, disableNavigation = _b.disableNavigation, styles = _b.styles, captionLayout = _b.captionLayout, components = _b.components;\n    var CaptionLabelComponent = (_a = components === null || components === void 0 ? void 0 : components.CaptionLabel) !== null && _a !== void 0 ? _a : CaptionLabel;\n    var caption;\n    if (disableNavigation) {\n        caption = (jsxRuntime.jsx(CaptionLabelComponent, { id: props.id, displayMonth: props.displayMonth }));\n    }\n    else if (captionLayout === 'dropdown') {\n        caption = (jsxRuntime.jsx(CaptionDropdowns, { displayMonth: props.displayMonth, id: props.id }));\n    }\n    else if (captionLayout === 'dropdown-buttons') {\n        caption = (jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [jsxRuntime.jsx(CaptionDropdowns, { displayMonth: props.displayMonth, displayIndex: props.displayIndex, id: props.id }), jsxRuntime.jsx(CaptionNavigation, { displayMonth: props.displayMonth, displayIndex: props.displayIndex, id: props.id })] }));\n    }\n    else {\n        caption = (jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [jsxRuntime.jsx(CaptionLabelComponent, { id: props.id, displayMonth: props.displayMonth, displayIndex: props.displayIndex }), jsxRuntime.jsx(CaptionNavigation, { displayMonth: props.displayMonth, id: props.id })] }));\n    }\n    return (jsxRuntime.jsx(\"div\", { className: classNames.caption, style: styles.caption, children: caption }));\n}\n\n/** Render the Footer component (empty as default).*/\n// eslint-disable-next-line @typescript-eslint/no-unused-vars\nfunction Footer(props) {\n    var _a = useDayPicker(), footer = _a.footer, styles = _a.styles, tfoot = _a.classNames.tfoot;\n    if (!footer)\n        return jsxRuntime.jsx(jsxRuntime.Fragment, {});\n    return (jsxRuntime.jsx(\"tfoot\", { className: tfoot, style: styles.tfoot, children: jsxRuntime.jsx(\"tr\", { children: jsxRuntime.jsx(\"td\", { colSpan: 8, children: footer }) }) }));\n}\n\n/**\n * Generate a series of 7 days, starting from the week, to use for formatting\n * the weekday names (Monday, Tuesday, etc.).\n */\nfunction getWeekdays(locale, \n/** The index of the first day of the week (0 - Sunday). */\nweekStartsOn, \n/** Use ISOWeek instead of locale/ */\nISOWeek) {\n    var start = ISOWeek\n        ? dateFns.startOfISOWeek(new Date())\n        : dateFns.startOfWeek(new Date(), { locale: locale, weekStartsOn: weekStartsOn });\n    var days = [];\n    for (var i = 0; i < 7; i++) {\n        var day = dateFns.addDays(start, i);\n        days.push(day);\n    }\n    return days;\n}\n\n/**\n * Render the HeadRow component - i.e. the table head row with the weekday names.\n */\nfunction HeadRow() {\n    var _a = useDayPicker(), classNames = _a.classNames, styles = _a.styles, showWeekNumber = _a.showWeekNumber, locale = _a.locale, weekStartsOn = _a.weekStartsOn, ISOWeek = _a.ISOWeek, formatWeekdayName = _a.formatters.formatWeekdayName, labelWeekday = _a.labels.labelWeekday;\n    var weekdays = getWeekdays(locale, weekStartsOn, ISOWeek);\n    return (jsxRuntime.jsxs(\"tr\", { style: styles.head_row, className: classNames.head_row, children: [showWeekNumber && (jsxRuntime.jsx(\"td\", { style: styles.head_cell, className: classNames.head_cell })), weekdays.map(function (weekday, i) { return (jsxRuntime.jsx(\"th\", { scope: \"col\", className: classNames.head_cell, style: styles.head_cell, \"aria-label\": labelWeekday(weekday, { locale: locale }), children: formatWeekdayName(weekday, { locale: locale }) }, i)); })] }));\n}\n\n/** Render the table head. */\nfunction Head() {\n    var _a;\n    var _b = useDayPicker(), classNames = _b.classNames, styles = _b.styles, components = _b.components;\n    var HeadRowComponent = (_a = components === null || components === void 0 ? void 0 : components.HeadRow) !== null && _a !== void 0 ? _a : HeadRow;\n    return (jsxRuntime.jsx(\"thead\", { style: styles.head, className: classNames.head, children: jsxRuntime.jsx(HeadRowComponent, {}) }));\n}\n\n/** Render the content of the day cell. */\nfunction DayContent(props) {\n    var _a = useDayPicker(), locale = _a.locale, formatDay = _a.formatters.formatDay;\n    return jsxRuntime.jsx(jsxRuntime.Fragment, { children: formatDay(props.date, { locale: locale }) });\n}\n\n/**\n * The SelectMultiple context shares details about the selected days when in\n * multiple selection mode.\n *\n * Access this context from the {@link useSelectMultiple} hook.\n */\nvar SelectMultipleContext = react.createContext(undefined);\n/** Provides the values for the {@link SelectMultipleContext}. */\nfunction SelectMultipleProvider(props) {\n    if (!isDayPickerMultiple(props.initialProps)) {\n        var emptyContextValue = {\n            selected: undefined,\n            modifiers: {\n                disabled: []\n            }\n        };\n        return (jsxRuntime.jsx(SelectMultipleContext.Provider, { value: emptyContextValue, children: props.children }));\n    }\n    return (jsxRuntime.jsx(SelectMultipleProviderInternal, { initialProps: props.initialProps, children: props.children }));\n}\nfunction SelectMultipleProviderInternal(_a) {\n    var initialProps = _a.initialProps, children = _a.children;\n    var selected = initialProps.selected, min = initialProps.min, max = initialProps.max;\n    var onDayClick = function (day, activeModifiers, e) {\n        var _a, _b;\n        (_a = initialProps.onDayClick) === null || _a === void 0 ? void 0 : _a.call(initialProps, day, activeModifiers, e);\n        var isMinSelected = Boolean(activeModifiers.selected && min && (selected === null || selected === void 0 ? void 0 : selected.length) === min);\n        if (isMinSelected) {\n            return;\n        }\n        var isMaxSelected = Boolean(!activeModifiers.selected && max && (selected === null || selected === void 0 ? void 0 : selected.length) === max);\n        if (isMaxSelected) {\n            return;\n        }\n        var selectedDays = selected ? __spreadArray([], selected, true) : [];\n        if (activeModifiers.selected) {\n            var index = selectedDays.findIndex(function (selectedDay) {\n                return dateFns.isSameDay(day, selectedDay);\n            });\n            selectedDays.splice(index, 1);\n        }\n        else {\n            selectedDays.push(day);\n        }\n        (_b = initialProps.onSelect) === null || _b === void 0 ? void 0 : _b.call(initialProps, selectedDays, day, activeModifiers, e);\n    };\n    var modifiers = {\n        disabled: []\n    };\n    if (selected) {\n        modifiers.disabled.push(function (day) {\n            var isMaxSelected = max && selected.length > max - 1;\n            var isSelected = selected.some(function (selectedDay) {\n                return dateFns.isSameDay(selectedDay, day);\n            });\n            return Boolean(isMaxSelected && !isSelected);\n        });\n    }\n    var contextValue = {\n        selected: selected,\n        onDayClick: onDayClick,\n        modifiers: modifiers\n    };\n    return (jsxRuntime.jsx(SelectMultipleContext.Provider, { value: contextValue, children: children }));\n}\n/**\n * Hook to access the {@link SelectMultipleContextValue}.\n *\n * This hook is meant to be used inside internal or custom components.\n */\nfunction useSelectMultiple() {\n    var context = react.useContext(SelectMultipleContext);\n    if (!context) {\n        throw new Error('useSelectMultiple must be used within a SelectMultipleProvider');\n    }\n    return context;\n}\n\n/**\n * Add a day to an existing range.\n *\n * The returned range takes in account the `undefined` values and if the added\n * day is already present in the range.\n */\nfunction addToRange(day, range) {\n    var _a = range || {}, from = _a.from, to = _a.to;\n    if (from && to) {\n        if (dateFns.isSameDay(to, day) && dateFns.isSameDay(from, day)) {\n            return undefined;\n        }\n        if (dateFns.isSameDay(to, day)) {\n            return { from: to, to: undefined };\n        }\n        if (dateFns.isSameDay(from, day)) {\n            return undefined;\n        }\n        if (dateFns.isAfter(from, day)) {\n            return { from: day, to: to };\n        }\n        return { from: from, to: day };\n    }\n    if (to) {\n        if (dateFns.isAfter(day, to)) {\n            return { from: to, to: day };\n        }\n        return { from: day, to: to };\n    }\n    if (from) {\n        if (dateFns.isBefore(day, from)) {\n            return { from: day, to: from };\n        }\n        return { from: from, to: day };\n    }\n    return { from: day, to: undefined };\n}\n\n/**\n * The SelectRange context shares details about the selected days when in\n * range selection mode.\n *\n * Access this context from the {@link useSelectRange} hook.\n */\nvar SelectRangeContext = react.createContext(undefined);\n/** Provides the values for the {@link SelectRangeProvider}. */\nfunction SelectRangeProvider(props) {\n    if (!isDayPickerRange(props.initialProps)) {\n        var emptyContextValue = {\n            selected: undefined,\n            modifiers: {\n                range_start: [],\n                range_end: [],\n                range_middle: [],\n                disabled: []\n            }\n        };\n        return (jsxRuntime.jsx(SelectRangeContext.Provider, { value: emptyContextValue, children: props.children }));\n    }\n    return (jsxRuntime.jsx(SelectRangeProviderInternal, { initialProps: props.initialProps, children: props.children }));\n}\nfunction SelectRangeProviderInternal(_a) {\n    var initialProps = _a.initialProps, children = _a.children;\n    var selected = initialProps.selected;\n    var _b = selected || {}, selectedFrom = _b.from, selectedTo = _b.to;\n    var min = initialProps.min;\n    var max = initialProps.max;\n    var onDayClick = function (day, activeModifiers, e) {\n        var _a, _b;\n        (_a = initialProps.onDayClick) === null || _a === void 0 ? void 0 : _a.call(initialProps, day, activeModifiers, e);\n        var newRange = addToRange(day, selected);\n        (_b = initialProps.onSelect) === null || _b === void 0 ? void 0 : _b.call(initialProps, newRange, day, activeModifiers, e);\n    };\n    var modifiers = {\n        range_start: [],\n        range_end: [],\n        range_middle: [],\n        disabled: []\n    };\n    if (selectedFrom) {\n        modifiers.range_start = [selectedFrom];\n        if (!selectedTo) {\n            modifiers.range_end = [selectedFrom];\n        }\n        else {\n            modifiers.range_end = [selectedTo];\n            if (!dateFns.isSameDay(selectedFrom, selectedTo)) {\n                modifiers.range_middle = [\n                    {\n                        after: selectedFrom,\n                        before: selectedTo\n                    }\n                ];\n            }\n        }\n    }\n    else if (selectedTo) {\n        modifiers.range_start = [selectedTo];\n        modifiers.range_end = [selectedTo];\n    }\n    if (min) {\n        if (selectedFrom && !selectedTo) {\n            modifiers.disabled.push({\n                after: dateFns.subDays(selectedFrom, min - 1),\n                before: dateFns.addDays(selectedFrom, min - 1)\n            });\n        }\n        if (selectedFrom && selectedTo) {\n            modifiers.disabled.push({\n                after: selectedFrom,\n                before: dateFns.addDays(selectedFrom, min - 1)\n            });\n        }\n        if (!selectedFrom && selectedTo) {\n            modifiers.disabled.push({\n                after: dateFns.subDays(selectedTo, min - 1),\n                before: dateFns.addDays(selectedTo, min - 1)\n            });\n        }\n    }\n    if (max) {\n        if (selectedFrom && !selectedTo) {\n            modifiers.disabled.push({\n                before: dateFns.addDays(selectedFrom, -max + 1)\n            });\n            modifiers.disabled.push({\n                after: dateFns.addDays(selectedFrom, max - 1)\n            });\n        }\n        if (selectedFrom && selectedTo) {\n            var selectedCount = dateFns.differenceInCalendarDays(selectedTo, selectedFrom) + 1;\n            var offset = max - selectedCount;\n            modifiers.disabled.push({\n                before: dateFns.subDays(selectedFrom, offset)\n            });\n            modifiers.disabled.push({\n                after: dateFns.addDays(selectedTo, offset)\n            });\n        }\n        if (!selectedFrom && selectedTo) {\n            modifiers.disabled.push({\n                before: dateFns.addDays(selectedTo, -max + 1)\n            });\n            modifiers.disabled.push({\n                after: dateFns.addDays(selectedTo, max - 1)\n            });\n        }\n    }\n    return (jsxRuntime.jsx(SelectRangeContext.Provider, { value: { selected: selected, onDayClick: onDayClick, modifiers: modifiers }, children: children }));\n}\n/**\n * Hook to access the {@link SelectRangeContextValue}.\n *\n * This hook is meant to be used inside internal or custom components.\n */\nfunction useSelectRange() {\n    var context = react.useContext(SelectRangeContext);\n    if (!context) {\n        throw new Error('useSelectRange must be used within a SelectRangeProvider');\n    }\n    return context;\n}\n\n/** Normalize to array a matcher input. */\nfunction matcherToArray(matcher) {\n    if (Array.isArray(matcher)) {\n        return __spreadArray([], matcher, true);\n    }\n    else if (matcher !== undefined) {\n        return [matcher];\n    }\n    else {\n        return [];\n    }\n}\n\n/** Create CustomModifiers from dayModifiers */\nfunction getCustomModifiers(dayModifiers) {\n    var customModifiers = {};\n    Object.entries(dayModifiers).forEach(function (_a) {\n        var modifier = _a[0], matcher = _a[1];\n        customModifiers[modifier] = matcherToArray(matcher);\n    });\n    return customModifiers;\n}\n\n/** The name of the modifiers that are used internally by DayPicker. */\nexports.InternalModifier = void 0;\n(function (InternalModifier) {\n    InternalModifier[\"Outside\"] = \"outside\";\n    /** Name of the modifier applied to the disabled days, using the `disabled` prop. */\n    InternalModifier[\"Disabled\"] = \"disabled\";\n    /** Name of the modifier applied to the selected days using the `selected` prop). */\n    InternalModifier[\"Selected\"] = \"selected\";\n    /** Name of the modifier applied to the hidden days using the `hidden` prop). */\n    InternalModifier[\"Hidden\"] = \"hidden\";\n    /** Name of the modifier applied to the day specified using the `today` prop). */\n    InternalModifier[\"Today\"] = \"today\";\n    /** The modifier applied to the day starting a selected range, when in range selection mode.  */\n    InternalModifier[\"RangeStart\"] = \"range_start\";\n    /** The modifier applied to the day ending a selected range, when in range selection mode.  */\n    InternalModifier[\"RangeEnd\"] = \"range_end\";\n    /** The modifier applied to the days between the start and the end of a selected range, when in range selection mode.  */\n    InternalModifier[\"RangeMiddle\"] = \"range_middle\";\n})(exports.InternalModifier || (exports.InternalModifier = {}));\n\nvar Selected = exports.InternalModifier.Selected, Disabled = exports.InternalModifier.Disabled, Hidden = exports.InternalModifier.Hidden, Today = exports.InternalModifier.Today, RangeEnd = exports.InternalModifier.RangeEnd, RangeMiddle = exports.InternalModifier.RangeMiddle, RangeStart = exports.InternalModifier.RangeStart, Outside = exports.InternalModifier.Outside;\n/** Return the {@link InternalModifiers} from the DayPicker and select contexts. */\nfunction getInternalModifiers(dayPicker, selectMultiple, selectRange) {\n    var _a;\n    var internalModifiers = (_a = {},\n        _a[Selected] = matcherToArray(dayPicker.selected),\n        _a[Disabled] = matcherToArray(dayPicker.disabled),\n        _a[Hidden] = matcherToArray(dayPicker.hidden),\n        _a[Today] = [dayPicker.today],\n        _a[RangeEnd] = [],\n        _a[RangeMiddle] = [],\n        _a[RangeStart] = [],\n        _a[Outside] = [],\n        _a);\n    if (dayPicker.fromDate) {\n        internalModifiers[Disabled].push({ before: dayPicker.fromDate });\n    }\n    if (dayPicker.toDate) {\n        internalModifiers[Disabled].push({ after: dayPicker.toDate });\n    }\n    if (isDayPickerMultiple(dayPicker)) {\n        internalModifiers[Disabled] = internalModifiers[Disabled].concat(selectMultiple.modifiers[Disabled]);\n    }\n    else if (isDayPickerRange(dayPicker)) {\n        internalModifiers[Disabled] = internalModifiers[Disabled].concat(selectRange.modifiers[Disabled]);\n        internalModifiers[RangeStart] = selectRange.modifiers[RangeStart];\n        internalModifiers[RangeMiddle] = selectRange.modifiers[RangeMiddle];\n        internalModifiers[RangeEnd] = selectRange.modifiers[RangeEnd];\n    }\n    return internalModifiers;\n}\n\n/** The Modifiers context store the modifiers used in DayPicker. To access the value of this context, use {@link useModifiers}. */\nvar ModifiersContext = react.createContext(undefined);\n/** Provide the value for the {@link ModifiersContext}. */\nfunction ModifiersProvider(props) {\n    var dayPicker = useDayPicker();\n    var selectMultiple = useSelectMultiple();\n    var selectRange = useSelectRange();\n    var internalModifiers = getInternalModifiers(dayPicker, selectMultiple, selectRange);\n    var customModifiers = getCustomModifiers(dayPicker.modifiers);\n    var modifiers = __assign(__assign({}, internalModifiers), customModifiers);\n    return (jsxRuntime.jsx(ModifiersContext.Provider, { value: modifiers, children: props.children }));\n}\n/**\n * Return the modifiers used by DayPicker.\n *\n * This hook is meant to be used inside internal or custom components.\n * Requires to be wrapped into {@link ModifiersProvider}.\n *\n */\nfunction useModifiers() {\n    var context = react.useContext(ModifiersContext);\n    if (!context) {\n        throw new Error('useModifiers must be used within a ModifiersProvider');\n    }\n    return context;\n}\n\n/** Returns true if `matcher` is of type {@link DateInterval}. */\nfunction isDateInterval(matcher) {\n    return Boolean(matcher &&\n        typeof matcher === 'object' &&\n        'before' in matcher &&\n        'after' in matcher);\n}\n/** Returns true if `value` is a {@link DateRange} type. */\nfunction isDateRange(value) {\n    return Boolean(value && typeof value === 'object' && 'from' in value);\n}\n/** Returns true if `value` is of type {@link DateAfter}. */\nfunction isDateAfterType(value) {\n    return Boolean(value && typeof value === 'object' && 'after' in value);\n}\n/** Returns true if `value` is of type {@link DateBefore}. */\nfunction isDateBeforeType(value) {\n    return Boolean(value && typeof value === 'object' && 'before' in value);\n}\n/** Returns true if `value` is a {@link DayOfWeek} type. */\nfunction isDayOfWeekType(value) {\n    return Boolean(value && typeof value === 'object' && 'dayOfWeek' in value);\n}\n\n/** Return `true` whether `date` is inside `range`. */\nfunction isDateInRange(date, range) {\n    var _a;\n    var from = range.from, to = range.to;\n    if (from && to) {\n        var isRangeInverted = dateFns.differenceInCalendarDays(to, from) < 0;\n        if (isRangeInverted) {\n            _a = [to, from], from = _a[0], to = _a[1];\n        }\n        var isInRange = dateFns.differenceInCalendarDays(date, from) >= 0 &&\n            dateFns.differenceInCalendarDays(to, date) >= 0;\n        return isInRange;\n    }\n    if (to) {\n        return dateFns.isSameDay(to, date);\n    }\n    if (from) {\n        return dateFns.isSameDay(from, date);\n    }\n    return false;\n}\n\n/** Returns true if `value` is a Date type. */\nfunction isDateType(value) {\n    return dateFns.isDate(value);\n}\n/** Returns true if `value` is an array of valid dates. */\nfunction isArrayOfDates(value) {\n    return Array.isArray(value) && value.every(dateFns.isDate);\n}\n/**\n * Returns whether a day matches against at least one of the given Matchers.\n *\n * ```\n * const day = new Date(2022, 5, 19);\n * const matcher1: DateRange = {\n *    from: new Date(2021, 12, 21),\n *    to: new Date(2021, 12, 30)\n * }\n * const matcher2: DateRange = {\n *    from: new Date(2022, 5, 1),\n *    to: new Date(2022, 5, 23)\n * }\n *\n * const isMatch(day, [matcher1, matcher2]); // true, since day is in the matcher1 range.\n * ```\n * */\nfunction isMatch(day, matchers) {\n    return matchers.some(function (matcher) {\n        if (typeof matcher === 'boolean') {\n            return matcher;\n        }\n        if (isDateType(matcher)) {\n            return dateFns.isSameDay(day, matcher);\n        }\n        if (isArrayOfDates(matcher)) {\n            return matcher.includes(day);\n        }\n        if (isDateRange(matcher)) {\n            return isDateInRange(day, matcher);\n        }\n        if (isDayOfWeekType(matcher)) {\n            return matcher.dayOfWeek.includes(day.getDay());\n        }\n        if (isDateInterval(matcher)) {\n            var diffBefore = dateFns.differenceInCalendarDays(matcher.before, day);\n            var diffAfter = dateFns.differenceInCalendarDays(matcher.after, day);\n            var isDayBefore = diffBefore > 0;\n            var isDayAfter = diffAfter < 0;\n            var isClosedInterval = dateFns.isAfter(matcher.before, matcher.after);\n            if (isClosedInterval) {\n                return isDayAfter && isDayBefore;\n            }\n            else {\n                return isDayBefore || isDayAfter;\n            }\n        }\n        if (isDateAfterType(matcher)) {\n            return dateFns.differenceInCalendarDays(day, matcher.after) > 0;\n        }\n        if (isDateBeforeType(matcher)) {\n            return dateFns.differenceInCalendarDays(matcher.before, day) > 0;\n        }\n        if (typeof matcher === 'function') {\n            return matcher(day);\n        }\n        return false;\n    });\n}\n\n/** Return the active modifiers for the given day. */\nfunction getActiveModifiers(day, \n/** The modifiers to match for the given date. */\nmodifiers, \n/** The month where the day is displayed, to add the \"outside\" modifiers.  */\ndisplayMonth) {\n    var matchedModifiers = Object.keys(modifiers).reduce(function (result, key) {\n        var modifier = modifiers[key];\n        if (isMatch(day, modifier)) {\n            result.push(key);\n        }\n        return result;\n    }, []);\n    var activeModifiers = {};\n    matchedModifiers.forEach(function (modifier) { return (activeModifiers[modifier] = true); });\n    if (displayMonth && !dateFns.isSameMonth(day, displayMonth)) {\n        activeModifiers.outside = true;\n    }\n    return activeModifiers;\n}\n\n/**\n * Returns the day that should be the target of the focus when DayPicker is\n * rendered the first time.\n *\n * TODO: this function doesn't consider if the day is outside the month. We\n * implemented this check in `useDayRender` but it should probably go here. See\n * https://github.com/gpbl/react-day-picker/pull/1576\n */\nfunction getInitialFocusTarget(displayMonths, modifiers) {\n    var firstDayInMonth = dateFns.startOfMonth(displayMonths[0]);\n    var lastDayInMonth = dateFns.endOfMonth(displayMonths[displayMonths.length - 1]);\n    // TODO: cleanup code\n    var firstFocusableDay;\n    var today;\n    var date = firstDayInMonth;\n    while (date <= lastDayInMonth) {\n        var activeModifiers = getActiveModifiers(date, modifiers);\n        var isFocusable = !activeModifiers.disabled && !activeModifiers.hidden;\n        if (!isFocusable) {\n            date = dateFns.addDays(date, 1);\n            continue;\n        }\n        if (activeModifiers.selected) {\n            return date;\n        }\n        if (activeModifiers.today && !today) {\n            today = date;\n        }\n        if (!firstFocusableDay) {\n            firstFocusableDay = date;\n        }\n        date = dateFns.addDays(date, 1);\n    }\n    if (today) {\n        return today;\n    }\n    else {\n        return firstFocusableDay;\n    }\n}\n\nvar MAX_RETRY = 365;\n/** Return the next date to be focused. */\nfunction getNextFocus(focusedDay, options) {\n    var moveBy = options.moveBy, direction = options.direction, context = options.context, modifiers = options.modifiers, _a = options.retry, retry = _a === void 0 ? { count: 0, lastFocused: focusedDay } : _a;\n    var weekStartsOn = context.weekStartsOn, fromDate = context.fromDate, toDate = context.toDate, locale = context.locale;\n    var moveFns = {\n        day: dateFns.addDays,\n        week: dateFns.addWeeks,\n        month: dateFns.addMonths,\n        year: dateFns.addYears,\n        startOfWeek: function (date) {\n            return context.ISOWeek\n                ? dateFns.startOfISOWeek(date)\n                : dateFns.startOfWeek(date, { locale: locale, weekStartsOn: weekStartsOn });\n        },\n        endOfWeek: function (date) {\n            return context.ISOWeek\n                ? dateFns.endOfISOWeek(date)\n                : dateFns.endOfWeek(date, { locale: locale, weekStartsOn: weekStartsOn });\n        }\n    };\n    var newFocusedDay = moveFns[moveBy](focusedDay, direction === 'after' ? 1 : -1);\n    if (direction === 'before' && fromDate) {\n        newFocusedDay = dateFns.max([fromDate, newFocusedDay]);\n    }\n    else if (direction === 'after' && toDate) {\n        newFocusedDay = dateFns.min([toDate, newFocusedDay]);\n    }\n    var isFocusable = true;\n    if (modifiers) {\n        var activeModifiers = getActiveModifiers(newFocusedDay, modifiers);\n        isFocusable = !activeModifiers.disabled && !activeModifiers.hidden;\n    }\n    if (isFocusable) {\n        return newFocusedDay;\n    }\n    else {\n        if (retry.count > MAX_RETRY) {\n            return retry.lastFocused;\n        }\n        return getNextFocus(newFocusedDay, {\n            moveBy: moveBy,\n            direction: direction,\n            context: context,\n            modifiers: modifiers,\n            retry: __assign(__assign({}, retry), { count: retry.count + 1 })\n        });\n    }\n}\n\n/**\n * The Focus context shares details about the focused day for the keyboard\n *\n * Access this context from the {@link useFocusContext} hook.\n */\nvar FocusContext = react.createContext(undefined);\n/** The provider for the {@link FocusContext}. */\nfunction FocusProvider(props) {\n    var navigation = useNavigation();\n    var modifiers = useModifiers();\n    var _a = react.useState(), focusedDay = _a[0], setFocusedDay = _a[1];\n    var _b = react.useState(), lastFocused = _b[0], setLastFocused = _b[1];\n    var initialFocusTarget = getInitialFocusTarget(navigation.displayMonths, modifiers);\n    // TODO: cleanup and test obscure code below\n    var focusTarget = (focusedDay !== null && focusedDay !== void 0 ? focusedDay : (lastFocused && navigation.isDateDisplayed(lastFocused)))\n        ? lastFocused\n        : initialFocusTarget;\n    var blur = function () {\n        setLastFocused(focusedDay);\n        setFocusedDay(undefined);\n    };\n    var focus = function (date) {\n        setFocusedDay(date);\n    };\n    var context = useDayPicker();\n    var moveFocus = function (moveBy, direction) {\n        if (!focusedDay)\n            return;\n        var nextFocused = getNextFocus(focusedDay, {\n            moveBy: moveBy,\n            direction: direction,\n            context: context,\n            modifiers: modifiers\n        });\n        if (dateFns.isSameDay(focusedDay, nextFocused))\n            return undefined;\n        navigation.goToDate(nextFocused, focusedDay);\n        focus(nextFocused);\n    };\n    var value = {\n        focusedDay: focusedDay,\n        focusTarget: focusTarget,\n        blur: blur,\n        focus: focus,\n        focusDayAfter: function () { return moveFocus('day', 'after'); },\n        focusDayBefore: function () { return moveFocus('day', 'before'); },\n        focusWeekAfter: function () { return moveFocus('week', 'after'); },\n        focusWeekBefore: function () { return moveFocus('week', 'before'); },\n        focusMonthBefore: function () { return moveFocus('month', 'before'); },\n        focusMonthAfter: function () { return moveFocus('month', 'after'); },\n        focusYearBefore: function () { return moveFocus('year', 'before'); },\n        focusYearAfter: function () { return moveFocus('year', 'after'); },\n        focusStartOfWeek: function () { return moveFocus('startOfWeek', 'before'); },\n        focusEndOfWeek: function () { return moveFocus('endOfWeek', 'after'); }\n    };\n    return (jsxRuntime.jsx(FocusContext.Provider, { value: value, children: props.children }));\n}\n/**\n * Hook to access the {@link FocusContextValue}. Use this hook to handle the\n * focus state of the elements.\n *\n * This hook is meant to be used inside internal or custom components.\n */\nfunction useFocusContext() {\n    var context = react.useContext(FocusContext);\n    if (!context) {\n        throw new Error('useFocusContext must be used within a FocusProvider');\n    }\n    return context;\n}\n\n/**\n * Return the active modifiers for the specified day.\n *\n * This hook is meant to be used inside internal or custom components.\n *\n * @param day\n * @param displayMonth\n */\nfunction useActiveModifiers(day, \n/**\n * The month where the date is displayed. If not the same as `date`, the day\n * is an \"outside day\".\n */\ndisplayMonth) {\n    var modifiers = useModifiers();\n    var activeModifiers = getActiveModifiers(day, modifiers, displayMonth);\n    return activeModifiers;\n}\n\n/**\n * The SelectSingle context shares details about the selected days when in\n * single selection mode.\n *\n * Access this context from the {@link useSelectSingle} hook.\n */\nvar SelectSingleContext = react.createContext(undefined);\n/** Provides the values for the {@link SelectSingleProvider}. */\nfunction SelectSingleProvider(props) {\n    if (!isDayPickerSingle(props.initialProps)) {\n        var emptyContextValue = {\n            selected: undefined\n        };\n        return (jsxRuntime.jsx(SelectSingleContext.Provider, { value: emptyContextValue, children: props.children }));\n    }\n    return (jsxRuntime.jsx(SelectSingleProviderInternal, { initialProps: props.initialProps, children: props.children }));\n}\nfunction SelectSingleProviderInternal(_a) {\n    var initialProps = _a.initialProps, children = _a.children;\n    var onDayClick = function (day, activeModifiers, e) {\n        var _a, _b, _c;\n        (_a = initialProps.onDayClick) === null || _a === void 0 ? void 0 : _a.call(initialProps, day, activeModifiers, e);\n        if (activeModifiers.selected && !initialProps.required) {\n            (_b = initialProps.onSelect) === null || _b === void 0 ? void 0 : _b.call(initialProps, undefined, day, activeModifiers, e);\n            return;\n        }\n        (_c = initialProps.onSelect) === null || _c === void 0 ? void 0 : _c.call(initialProps, day, day, activeModifiers, e);\n    };\n    var contextValue = {\n        selected: initialProps.selected,\n        onDayClick: onDayClick\n    };\n    return (jsxRuntime.jsx(SelectSingleContext.Provider, { value: contextValue, children: children }));\n}\n/**\n * Hook to access the {@link SelectSingleContextValue}.\n *\n * This hook is meant to be used inside internal or custom components.\n */\nfunction useSelectSingle() {\n    var context = react.useContext(SelectSingleContext);\n    if (!context) {\n        throw new Error('useSelectSingle must be used within a SelectSingleProvider');\n    }\n    return context;\n}\n\n/**\n * This hook returns details about the content to render in the day cell.\n *\n *\n * When a day cell is rendered in the table, DayPicker can either:\n *\n * - render nothing: when the day is outside the month or has matched the\n *   \"hidden\" modifier.\n * - render a button when `onDayClick` or a selection mode is set.\n * - render a non-interactive element: when no selection mode is set, the day\n *   cell shouldn’t respond to any interaction. DayPicker should render a `div`\n *   or a `span`.\n *\n * ### Usage\n *\n * Use this hook to customize the behavior of the {@link Day} component. Create a\n * new `Day` component using this hook and pass it to the `components` prop.\n * The source of {@link Day} can be a good starting point.\n *\n */\nfunction useDayEventHandlers(date, activeModifiers) {\n    var dayPicker = useDayPicker();\n    var single = useSelectSingle();\n    var multiple = useSelectMultiple();\n    var range = useSelectRange();\n    var _a = useFocusContext(), focusDayAfter = _a.focusDayAfter, focusDayBefore = _a.focusDayBefore, focusWeekAfter = _a.focusWeekAfter, focusWeekBefore = _a.focusWeekBefore, blur = _a.blur, focus = _a.focus, focusMonthBefore = _a.focusMonthBefore, focusMonthAfter = _a.focusMonthAfter, focusYearBefore = _a.focusYearBefore, focusYearAfter = _a.focusYearAfter, focusStartOfWeek = _a.focusStartOfWeek, focusEndOfWeek = _a.focusEndOfWeek;\n    var onClick = function (e) {\n        var _a, _b, _c, _d;\n        if (isDayPickerSingle(dayPicker)) {\n            (_a = single.onDayClick) === null || _a === void 0 ? void 0 : _a.call(single, date, activeModifiers, e);\n        }\n        else if (isDayPickerMultiple(dayPicker)) {\n            (_b = multiple.onDayClick) === null || _b === void 0 ? void 0 : _b.call(multiple, date, activeModifiers, e);\n        }\n        else if (isDayPickerRange(dayPicker)) {\n            (_c = range.onDayClick) === null || _c === void 0 ? void 0 : _c.call(range, date, activeModifiers, e);\n        }\n        else {\n            (_d = dayPicker.onDayClick) === null || _d === void 0 ? void 0 : _d.call(dayPicker, date, activeModifiers, e);\n        }\n    };\n    var onFocus = function (e) {\n        var _a;\n        focus(date);\n        (_a = dayPicker.onDayFocus) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onBlur = function (e) {\n        var _a;\n        blur();\n        (_a = dayPicker.onDayBlur) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onMouseEnter = function (e) {\n        var _a;\n        (_a = dayPicker.onDayMouseEnter) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onMouseLeave = function (e) {\n        var _a;\n        (_a = dayPicker.onDayMouseLeave) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onPointerEnter = function (e) {\n        var _a;\n        (_a = dayPicker.onDayPointerEnter) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onPointerLeave = function (e) {\n        var _a;\n        (_a = dayPicker.onDayPointerLeave) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onTouchCancel = function (e) {\n        var _a;\n        (_a = dayPicker.onDayTouchCancel) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onTouchEnd = function (e) {\n        var _a;\n        (_a = dayPicker.onDayTouchEnd) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onTouchMove = function (e) {\n        var _a;\n        (_a = dayPicker.onDayTouchMove) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onTouchStart = function (e) {\n        var _a;\n        (_a = dayPicker.onDayTouchStart) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onKeyUp = function (e) {\n        var _a;\n        (_a = dayPicker.onDayKeyUp) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var onKeyDown = function (e) {\n        var _a;\n        switch (e.key) {\n            case 'ArrowLeft':\n                e.preventDefault();\n                e.stopPropagation();\n                dayPicker.dir === 'rtl' ? focusDayAfter() : focusDayBefore();\n                break;\n            case 'ArrowRight':\n                e.preventDefault();\n                e.stopPropagation();\n                dayPicker.dir === 'rtl' ? focusDayBefore() : focusDayAfter();\n                break;\n            case 'ArrowDown':\n                e.preventDefault();\n                e.stopPropagation();\n                focusWeekAfter();\n                break;\n            case 'ArrowUp':\n                e.preventDefault();\n                e.stopPropagation();\n                focusWeekBefore();\n                break;\n            case 'PageUp':\n                e.preventDefault();\n                e.stopPropagation();\n                e.shiftKey ? focusYearBefore() : focusMonthBefore();\n                break;\n            case 'PageDown':\n                e.preventDefault();\n                e.stopPropagation();\n                e.shiftKey ? focusYearAfter() : focusMonthAfter();\n                break;\n            case 'Home':\n                e.preventDefault();\n                e.stopPropagation();\n                focusStartOfWeek();\n                break;\n            case 'End':\n                e.preventDefault();\n                e.stopPropagation();\n                focusEndOfWeek();\n                break;\n        }\n        (_a = dayPicker.onDayKeyDown) === null || _a === void 0 ? void 0 : _a.call(dayPicker, date, activeModifiers, e);\n    };\n    var eventHandlers = {\n        onClick: onClick,\n        onFocus: onFocus,\n        onBlur: onBlur,\n        onKeyDown: onKeyDown,\n        onKeyUp: onKeyUp,\n        onMouseEnter: onMouseEnter,\n        onMouseLeave: onMouseLeave,\n        onPointerEnter: onPointerEnter,\n        onPointerLeave: onPointerLeave,\n        onTouchCancel: onTouchCancel,\n        onTouchEnd: onTouchEnd,\n        onTouchMove: onTouchMove,\n        onTouchStart: onTouchStart\n    };\n    return eventHandlers;\n}\n\n/**\n * Return the current selected days when DayPicker is in selection mode. Days\n * selected by the custom selection mode are not returned.\n *\n * This hook is meant to be used inside internal or custom components.\n *\n */\nfunction useSelectedDays() {\n    var dayPicker = useDayPicker();\n    var single = useSelectSingle();\n    var multiple = useSelectMultiple();\n    var range = useSelectRange();\n    var selectedDays = isDayPickerSingle(dayPicker)\n        ? single.selected\n        : isDayPickerMultiple(dayPicker)\n            ? multiple.selected\n            : isDayPickerRange(dayPicker)\n                ? range.selected\n                : undefined;\n    return selectedDays;\n}\n\nfunction isInternalModifier(modifier) {\n    return Object.values(exports.InternalModifier).includes(modifier);\n}\n/**\n * Return the class names for the Day element, according to the given active\n * modifiers.\n *\n * Custom class names are set via `modifiersClassNames` or `classNames`,\n * where the first have the precedence.\n */\nfunction getDayClassNames(dayPicker, activeModifiers) {\n    var classNames = [dayPicker.classNames.day];\n    Object.keys(activeModifiers).forEach(function (modifier) {\n        var customClassName = dayPicker.modifiersClassNames[modifier];\n        if (customClassName) {\n            classNames.push(customClassName);\n        }\n        else if (isInternalModifier(modifier)) {\n            var internalClassName = dayPicker.classNames[\"day_\".concat(modifier)];\n            if (internalClassName) {\n                classNames.push(internalClassName);\n            }\n        }\n    });\n    return classNames;\n}\n\n/** Return the style for the Day element, according to the given active modifiers. */\nfunction getDayStyle(dayPicker, activeModifiers) {\n    var style = __assign({}, dayPicker.styles.day);\n    Object.keys(activeModifiers).forEach(function (modifier) {\n        var _a;\n        style = __assign(__assign({}, style), (_a = dayPicker.modifiersStyles) === null || _a === void 0 ? void 0 : _a[modifier]);\n    });\n    return style;\n}\n\n/**\n * Return props and data used to render the {@link Day} component.\n *\n * Use this hook when creating a component to replace the built-in `Day`\n * component.\n */\nfunction useDayRender(\n/** The date to render. */\nday, \n/** The month where the date is displayed (if not the same as `date`, it means it is an \"outside\" day). */\ndisplayMonth, \n/** A ref to the button element that will be target of focus when rendered (if required). */\nbuttonRef) {\n    var _a;\n    var _b, _c;\n    var dayPicker = useDayPicker();\n    var focusContext = useFocusContext();\n    var activeModifiers = useActiveModifiers(day, displayMonth);\n    var eventHandlers = useDayEventHandlers(day, activeModifiers);\n    var selectedDays = useSelectedDays();\n    var isButton = Boolean(dayPicker.onDayClick || dayPicker.mode !== 'default');\n    // Focus the button if the day is focused according to the focus context\n    react.useEffect(function () {\n        var _a;\n        if (activeModifiers.outside)\n            return;\n        if (!focusContext.focusedDay)\n            return;\n        if (!isButton)\n            return;\n        if (dateFns.isSameDay(focusContext.focusedDay, day)) {\n            (_a = buttonRef.current) === null || _a === void 0 ? void 0 : _a.focus();\n        }\n    }, [\n        focusContext.focusedDay,\n        day,\n        buttonRef,\n        isButton,\n        activeModifiers.outside\n    ]);\n    var className = getDayClassNames(dayPicker, activeModifiers).join(' ');\n    var style = getDayStyle(dayPicker, activeModifiers);\n    var isHidden = Boolean((activeModifiers.outside && !dayPicker.showOutsideDays) ||\n        activeModifiers.hidden);\n    var DayContentComponent = (_c = (_b = dayPicker.components) === null || _b === void 0 ? void 0 : _b.DayContent) !== null && _c !== void 0 ? _c : DayContent;\n    var children = (jsxRuntime.jsx(DayContentComponent, { date: day, displayMonth: displayMonth, activeModifiers: activeModifiers }));\n    var divProps = {\n        style: style,\n        className: className,\n        children: children,\n        role: 'gridcell'\n    };\n    var isFocusTarget = focusContext.focusTarget &&\n        dateFns.isSameDay(focusContext.focusTarget, day) &&\n        !activeModifiers.outside;\n    var isFocused = focusContext.focusedDay && dateFns.isSameDay(focusContext.focusedDay, day);\n    var buttonProps = __assign(__assign(__assign({}, divProps), (_a = { disabled: activeModifiers.disabled, role: 'gridcell' }, _a['aria-selected'] = activeModifiers.selected, _a.tabIndex = isFocused || isFocusTarget ? 0 : -1, _a)), eventHandlers);\n    var dayRender = {\n        isButton: isButton,\n        isHidden: isHidden,\n        activeModifiers: activeModifiers,\n        selectedDays: selectedDays,\n        buttonProps: buttonProps,\n        divProps: divProps\n    };\n    return dayRender;\n}\n\n/**\n * The content of a day cell – as a button or span element according to its\n * modifiers.\n */\nfunction Day(props) {\n    var buttonRef = react.useRef(null);\n    var dayRender = useDayRender(props.date, props.displayMonth, buttonRef);\n    if (dayRender.isHidden) {\n        return jsxRuntime.jsx(\"div\", { role: \"gridcell\" });\n    }\n    if (!dayRender.isButton) {\n        return jsxRuntime.jsx(\"div\", __assign({}, dayRender.divProps));\n    }\n    return jsxRuntime.jsx(Button, __assign({ name: \"day\", ref: buttonRef }, dayRender.buttonProps));\n}\n\n/**\n * Render the week number element. If `onWeekNumberClick` is passed to DayPicker, it\n * renders a button, otherwise a span element.\n */\nfunction WeekNumber(props) {\n    var weekNumber = props.number, dates = props.dates;\n    var _a = useDayPicker(), onWeekNumberClick = _a.onWeekNumberClick, styles = _a.styles, classNames = _a.classNames, locale = _a.locale, labelWeekNumber = _a.labels.labelWeekNumber, formatWeekNumber = _a.formatters.formatWeekNumber;\n    var content = formatWeekNumber(Number(weekNumber), { locale: locale });\n    if (!onWeekNumberClick) {\n        return (jsxRuntime.jsx(\"span\", { className: classNames.weeknumber, style: styles.weeknumber, children: content }));\n    }\n    var label = labelWeekNumber(Number(weekNumber), { locale: locale });\n    var handleClick = function (e) {\n        onWeekNumberClick(weekNumber, dates, e);\n    };\n    return (jsxRuntime.jsx(Button, { name: \"week-number\", \"aria-label\": label, className: classNames.weeknumber, style: styles.weeknumber, onClick: handleClick, children: content }));\n}\n\n/** Render a row in the calendar, with the days and the week number. */\nfunction Row(props) {\n    var _a, _b;\n    var _c = useDayPicker(), styles = _c.styles, classNames = _c.classNames, showWeekNumber = _c.showWeekNumber, components = _c.components;\n    var DayComponent = (_a = components === null || components === void 0 ? void 0 : components.Day) !== null && _a !== void 0 ? _a : Day;\n    var WeeknumberComponent = (_b = components === null || components === void 0 ? void 0 : components.WeekNumber) !== null && _b !== void 0 ? _b : WeekNumber;\n    var weekNumberCell;\n    if (showWeekNumber) {\n        weekNumberCell = (jsxRuntime.jsx(\"td\", { className: classNames.cell, style: styles.cell, children: jsxRuntime.jsx(WeeknumberComponent, { number: props.weekNumber, dates: props.dates }) }));\n    }\n    return (jsxRuntime.jsxs(\"tr\", { className: classNames.row, style: styles.row, children: [weekNumberCell, props.dates.map(function (date) { return (jsxRuntime.jsx(\"td\", { className: classNames.cell, style: styles.cell, role: \"presentation\", children: jsxRuntime.jsx(DayComponent, { displayMonth: props.displayMonth, date: date }) }, dateFns.getUnixTime(date))); })] }));\n}\n\n/** Return the weeks between two dates.  */\nfunction daysToMonthWeeks(fromDate, toDate, options) {\n    var toWeek = (options === null || options === void 0 ? void 0 : options.ISOWeek)\n        ? dateFns.endOfISOWeek(toDate)\n        : dateFns.endOfWeek(toDate, options);\n    var fromWeek = (options === null || options === void 0 ? void 0 : options.ISOWeek)\n        ? dateFns.startOfISOWeek(fromDate)\n        : dateFns.startOfWeek(fromDate, options);\n    var nOfDays = dateFns.differenceInCalendarDays(toWeek, fromWeek);\n    var days = [];\n    for (var i = 0; i <= nOfDays; i++) {\n        days.push(dateFns.addDays(fromWeek, i));\n    }\n    var weeksInMonth = days.reduce(function (result, date) {\n        var weekNumber = (options === null || options === void 0 ? void 0 : options.ISOWeek)\n            ? dateFns.getISOWeek(date)\n            : dateFns.getWeek(date, options);\n        var existingWeek = result.find(function (value) { return value.weekNumber === weekNumber; });\n        if (existingWeek) {\n            existingWeek.dates.push(date);\n            return result;\n        }\n        result.push({\n            weekNumber: weekNumber,\n            dates: [date]\n        });\n        return result;\n    }, []);\n    return weeksInMonth;\n}\n\n/**\n * Return the weeks belonging to the given month, adding the \"outside days\" to\n * the first and last week.\n */\nfunction getMonthWeeks(month, options) {\n    var weeksInMonth = daysToMonthWeeks(dateFns.startOfMonth(month), dateFns.endOfMonth(month), options);\n    if (options === null || options === void 0 ? void 0 : options.useFixedWeeks) {\n        // Add extra weeks to the month, up to 6 weeks\n        var nrOfMonthWeeks = dateFns.getWeeksInMonth(month, options);\n        if (nrOfMonthWeeks < 6) {\n            var lastWeek = weeksInMonth[weeksInMonth.length - 1];\n            var lastDate = lastWeek.dates[lastWeek.dates.length - 1];\n            var toDate = dateFns.addWeeks(lastDate, 6 - nrOfMonthWeeks);\n            var extraWeeks = daysToMonthWeeks(dateFns.addWeeks(lastDate, 1), toDate, options);\n            weeksInMonth.push.apply(weeksInMonth, extraWeeks);\n        }\n    }\n    return weeksInMonth;\n}\n\n/** Render the table with the calendar. */\nfunction Table(props) {\n    var _a, _b, _c;\n    var _d = useDayPicker(), locale = _d.locale, classNames = _d.classNames, styles = _d.styles, hideHead = _d.hideHead, fixedWeeks = _d.fixedWeeks, components = _d.components, weekStartsOn = _d.weekStartsOn, firstWeekContainsDate = _d.firstWeekContainsDate, ISOWeek = _d.ISOWeek;\n    var weeks = getMonthWeeks(props.displayMonth, {\n        useFixedWeeks: Boolean(fixedWeeks),\n        ISOWeek: ISOWeek,\n        locale: locale,\n        weekStartsOn: weekStartsOn,\n        firstWeekContainsDate: firstWeekContainsDate\n    });\n    var HeadComponent = (_a = components === null || components === void 0 ? void 0 : components.Head) !== null && _a !== void 0 ? _a : Head;\n    var RowComponent = (_b = components === null || components === void 0 ? void 0 : components.Row) !== null && _b !== void 0 ? _b : Row;\n    var FooterComponent = (_c = components === null || components === void 0 ? void 0 : components.Footer) !== null && _c !== void 0 ? _c : Footer;\n    return (jsxRuntime.jsxs(\"table\", { id: props.id, className: classNames.table, style: styles.table, role: \"grid\", \"aria-labelledby\": props['aria-labelledby'], children: [!hideHead && jsxRuntime.jsx(HeadComponent, {}), jsxRuntime.jsx(\"tbody\", { className: classNames.tbody, style: styles.tbody, children: weeks.map(function (week) { return (jsxRuntime.jsx(RowComponent, { displayMonth: props.displayMonth, dates: week.dates, weekNumber: week.weekNumber }, week.weekNumber)); }) }), jsxRuntime.jsx(FooterComponent, { displayMonth: props.displayMonth })] }));\n}\n\n/*\nThe MIT License (MIT)\n\nCopyright (c) 2018-present, React Training LLC\n\nPermission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n\nThe above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.\n\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n*/\n/* eslint-disable prefer-const */\n/* eslint-disable @typescript-eslint/ban-ts-comment */\n/*\n * Welcome to @reach/auto-id!\n * Let's see if we can make sense of why this hook exists and its\n * implementation.\n *\n * Some background:\n *   1. Accessibility APIs rely heavily on element IDs\n *   2. Requiring developers to put IDs on every element in Reach UI is both\n *      cumbersome and error-prone\n *   3. With a component model, we can generate IDs for them!\n *\n * Solution 1: Generate random IDs.\n *\n * This works great as long as you don't server render your app. When React (in\n * the client) tries to reuse the markup from the server, the IDs won't match\n * and React will then recreate the entire DOM tree.\n *\n * Solution 2: Increment an integer\n *\n * This sounds great. Since we're rendering the exact same tree on the server\n * and client, we can increment a counter and get a deterministic result between\n * client and server. Also, JS integers can go up to nine-quadrillion. I'm\n * pretty sure the tab will be closed before an app never needs\n * 10 quadrillion IDs!\n *\n * Problem solved, right?\n *\n * Ah, but there's a catch! React's concurrent rendering makes this approach\n * non-deterministic. While the client and server will end up with the same\n * elements in the end, depending on suspense boundaries (and possibly some user\n * input during the initial render) the incrementing integers won't always match\n * up.\n *\n * Solution 3: Don't use IDs at all on the server; patch after first render.\n *\n * What we've done here is solution 2 with some tricks. With this approach, the\n * ID returned is an empty string on the first render. This way the server and\n * client have the same markup no matter how wild the concurrent rendering may\n * have gotten.\n *\n * After the render, we patch up the components with an incremented ID. This\n * causes a double render on any components with `useId`. Shouldn't be a problem\n * since the components using this hook should be small, and we're only updating\n * the ID attribute on the DOM, nothing big is happening.\n *\n * It doesn't have to be an incremented number, though--we could do generate\n * random strings instead, but incrementing a number is probably the cheapest\n * thing we can do.\n *\n * Additionally, we only do this patchup on the very first client render ever.\n * Any calls to `useId` that happen dynamically in the client will be\n * populated immediately with a value. So, we only get the double render after\n * server hydration and never again, SO BACK OFF ALRIGHT?\n */\nfunction canUseDOM() {\n    return !!(typeof window !== 'undefined' &&\n        window.document &&\n        window.document.createElement);\n}\n/**\n * React currently throws a warning when using useLayoutEffect on the server. To\n * get around it, we can conditionally useEffect on the server (no-op) and\n * useLayoutEffect in the browser. We occasionally need useLayoutEffect to\n * ensure we don't get a render flash for certain operations, but we may also\n * need affected components to render on the server. One example is when setting\n * a component's descendants to retrieve their index values.\n *\n * Important to note that using this hook as an escape hatch will break the\n * eslint dependency warnings unless you rename the import to `useLayoutEffect`.\n * Use sparingly only when the effect won't effect the rendered HTML to avoid\n * any server/client mismatch.\n *\n * If a useLayoutEffect is needed and the result would create a mismatch, it's\n * likely that the component in question shouldn't be rendered on the server at\n * all, so a better approach would be to lazily render those in a parent\n * component after client-side hydration.\n *\n * https://gist.github.com/gaearon/e7d97cdf38a2907924ea12e4ebdf3c85\n * https://github.com/reduxjs/react-redux/blob/master/src/utils/useIsomorphicLayoutEffect.js\n *\n * @param effect\n * @param deps\n */\nvar useIsomorphicLayoutEffect = canUseDOM() ? react.useLayoutEffect : react.useEffect;\nvar serverHandoffComplete = false;\nvar id = 0;\nfunction genId() {\n    return \"react-day-picker-\".concat(++id);\n}\nfunction useId(providedId) {\n    // TODO: Remove error flag when updating internal deps to React 18. None of\n    // our tricks will play well with concurrent rendering anyway.\n    var _a;\n    // If this instance isn't part of the initial render, we don't have to do the\n    // double render/patch-up dance. We can just generate the ID and return it.\n    var initialId = providedId !== null && providedId !== void 0 ? providedId : (serverHandoffComplete ? genId() : null);\n    var _b = react.useState(initialId), id = _b[0], setId = _b[1];\n    useIsomorphicLayoutEffect(function () {\n        if (id === null) {\n            // Patch the ID after render. We do this in `useLayoutEffect` to avoid any\n            // rendering flicker, though it'll make the first render slower (unlikely\n            // to matter, but you're welcome to measure your app and let us know if\n            // it's a problem).\n            setId(genId());\n        }\n        // eslint-disable-next-line react-hooks/exhaustive-deps\n    }, []);\n    react.useEffect(function () {\n        if (serverHandoffComplete === false) {\n            // Flag all future uses of `useId` to skip the update dance. This is in\n            // `useEffect` because it goes after `useLayoutEffect`, ensuring we don't\n            // accidentally bail out of the patch-up dance prematurely.\n            serverHandoffComplete = true;\n        }\n    }, []);\n    return (_a = providedId !== null && providedId !== void 0 ? providedId : id) !== null && _a !== void 0 ? _a : undefined;\n}\n\n/** Render a month. */\nfunction Month(props) {\n    var _a;\n    var _b;\n    var dayPicker = useDayPicker();\n    var dir = dayPicker.dir, classNames = dayPicker.classNames, styles = dayPicker.styles, components = dayPicker.components;\n    var displayMonths = useNavigation().displayMonths;\n    var captionId = useId(dayPicker.id ? \"\".concat(dayPicker.id, \"-\").concat(props.displayIndex) : undefined);\n    var tableId = dayPicker.id\n        ? \"\".concat(dayPicker.id, \"-grid-\").concat(props.displayIndex)\n        : undefined;\n    var className = [classNames.month];\n    var style = styles.month;\n    var isStart = props.displayIndex === 0;\n    var isEnd = props.displayIndex === displayMonths.length - 1;\n    var isCenter = !isStart && !isEnd;\n    if (dir === 'rtl') {\n        _a = [isStart, isEnd], isEnd = _a[0], isStart = _a[1];\n    }\n    if (isStart) {\n        className.push(classNames.caption_start);\n        style = __assign(__assign({}, style), styles.caption_start);\n    }\n    if (isEnd) {\n        className.push(classNames.caption_end);\n        style = __assign(__assign({}, style), styles.caption_end);\n    }\n    if (isCenter) {\n        className.push(classNames.caption_between);\n        style = __assign(__assign({}, style), styles.caption_between);\n    }\n    var CaptionComponent = (_b = components === null || components === void 0 ? void 0 : components.Caption) !== null && _b !== void 0 ? _b : Caption;\n    return (jsxRuntime.jsxs(\"div\", { className: className.join(' '), style: style, children: [jsxRuntime.jsx(CaptionComponent, { id: captionId, displayMonth: props.displayMonth, displayIndex: props.displayIndex }), jsxRuntime.jsx(Table, { id: tableId, \"aria-labelledby\": captionId, displayMonth: props.displayMonth })] }, props.displayIndex));\n}\n\n/**\n * Render the wrapper for the month grids.\n */\nfunction Months(props) {\n    var _a = useDayPicker(), classNames = _a.classNames, styles = _a.styles;\n    return (jsxRuntime.jsx(\"div\", { className: classNames.months, style: styles.months, children: props.children }));\n}\n\n/** Render the container with the months according to the number of months to display. */\nfunction Root(_a) {\n    var _b, _c;\n    var initialProps = _a.initialProps;\n    var dayPicker = useDayPicker();\n    var focusContext = useFocusContext();\n    var navigation = useNavigation();\n    var _d = react.useState(false), hasInitialFocus = _d[0], setHasInitialFocus = _d[1];\n    // Focus the focus target when initialFocus is passed in\n    react.useEffect(function () {\n        if (!dayPicker.initialFocus)\n            return;\n        if (!focusContext.focusTarget)\n            return;\n        if (hasInitialFocus)\n            return;\n        focusContext.focus(focusContext.focusTarget);\n        setHasInitialFocus(true);\n    }, [\n        dayPicker.initialFocus,\n        hasInitialFocus,\n        focusContext.focus,\n        focusContext.focusTarget,\n        focusContext\n    ]);\n    // Apply classnames according to props\n    var classNames = [dayPicker.classNames.root, dayPicker.className];\n    if (dayPicker.numberOfMonths > 1) {\n        classNames.push(dayPicker.classNames.multiple_months);\n    }\n    if (dayPicker.showWeekNumber) {\n        classNames.push(dayPicker.classNames.with_weeknumber);\n    }\n    var style = __assign(__assign({}, dayPicker.styles.root), dayPicker.style);\n    var dataAttributes = Object.keys(initialProps)\n        .filter(function (key) { return key.startsWith('data-'); })\n        .reduce(function (attrs, key) {\n        var _a;\n        return __assign(__assign({}, attrs), (_a = {}, _a[key] = initialProps[key], _a));\n    }, {});\n    var MonthsComponent = (_c = (_b = initialProps.components) === null || _b === void 0 ? void 0 : _b.Months) !== null && _c !== void 0 ? _c : Months;\n    return (jsxRuntime.jsx(\"div\", __assign({ className: classNames.join(' '), style: style, dir: dayPicker.dir, id: dayPicker.id, nonce: initialProps.nonce, title: initialProps.title, lang: initialProps.lang }, dataAttributes, { children: jsxRuntime.jsx(MonthsComponent, { children: navigation.displayMonths.map(function (month, i) { return (jsxRuntime.jsx(Month, { displayIndex: i, displayMonth: month }, i)); }) }) })));\n}\n\n/** Provide the value for all the context providers. */\nfunction RootProvider(props) {\n    var children = props.children, initialProps = __rest(props, [\"children\"]);\n    return (jsxRuntime.jsx(DayPickerProvider, { initialProps: initialProps, children: jsxRuntime.jsx(NavigationProvider, { children: jsxRuntime.jsx(SelectSingleProvider, { initialProps: initialProps, children: jsxRuntime.jsx(SelectMultipleProvider, { initialProps: initialProps, children: jsxRuntime.jsx(SelectRangeProvider, { initialProps: initialProps, children: jsxRuntime.jsx(ModifiersProvider, { children: jsxRuntime.jsx(FocusProvider, { children: children }) }) }) }) }) }) }));\n}\n\n/**\n * DayPicker render a date picker component to let users pick dates from a\n * calendar. See http://react-day-picker.js.org for updated documentation and\n * examples.\n *\n * ### Customization\n *\n * DayPicker offers different customization props. For example,\n *\n * - show multiple months using `numberOfMonths`\n * - display a dropdown to navigate the months via `captionLayout`\n * - display the week numbers with `showWeekNumbers`\n * - disable or hide days with `disabled` or `hidden`\n *\n * ### Controlling the months\n *\n * Change the initially displayed month using the `defaultMonth` prop. The\n * displayed months are controlled by DayPicker and stored in its internal\n * state. To control the months yourself, use `month` instead of `defaultMonth`\n * and use the `onMonthChange` event to set it.\n *\n * To limit the months the user can navigate to, use\n * `fromDate`/`fromMonth`/`fromYear` or `toDate`/`toMonth`/`toYear`.\n *\n * ### Selection modes\n *\n * DayPicker supports different selection mode that can be toggled using the\n * `mode` prop:\n *\n * - `mode=\"single\"`: only one day can be selected. Use `required` to make the\n *   selection required. Use the `onSelect` event handler to get the selected\n *   days.\n * - `mode=\"multiple\"`: users can select one or more days. Limit the amount of\n *   days that can be selected with the `min` or the `max` props.\n * - `mode=\"range\"`: users can select a range of days. Limit the amount of days\n *   in the range with the `min` or the `max` props.\n * - `mode=\"default\"` (default): the built-in selections are disabled. Implement\n *   your own selection mode with `onDayClick`.\n *\n * The selection modes should cover the most common use cases. In case you\n * need a more refined way of selecting days, use `mode=\"default\"`. Use the\n * `selected` props and add the day event handlers to add/remove days from the\n * selection.\n *\n * ### Modifiers\n *\n * A _modifier_ represents different styles or states for the days displayed in\n * the calendar (like \"selected\" or \"disabled\"). Define custom modifiers using\n * the `modifiers` prop.\n *\n * ### Formatters and custom component\n *\n * You can customize how the content is displayed in the date picker by using\n * either the formatters or replacing the internal components.\n *\n * For the most common cases you want to use the `formatters` prop to change how\n * the content is formatted in the calendar. Use the `components` prop to\n * replace the internal components, like the navigation icons.\n *\n * ### Styling\n *\n * DayPicker comes with a default, basic style in `react-day-picker/style` – use\n * it as template for your own style.\n *\n * If you are using CSS modules, pass the imported styles object the\n * `classNames` props.\n *\n * You can also style the elements via inline styles using the `styles` prop.\n *\n * ### Form fields\n *\n * If you need to bind the date picker to a form field, you can use the\n * `useInput` hooks for a basic behavior. See the `useInput` source as an\n * example to bind the date picker with form fields.\n *\n * ### Localization\n *\n * To localize DayPicker, import the locale from `date-fns` package and use the\n * `locale` prop.\n *\n * For example, to use Spanish locale:\n *\n * ```\n * import { es } from 'date-fns/locale';\n * <DayPicker locale={es} />\n * ```\n */\nfunction DayPicker(props) {\n    return (jsxRuntime.jsx(RootProvider, __assign({}, props, { children: jsxRuntime.jsx(Root, { initialProps: props }) })));\n}\n\n/** @private */\nfunction isValidDate(day) {\n    return !isNaN(day.getTime());\n}\n\n/** Return props and setters for binding an input field to DayPicker. */\nfunction useInput(options) {\n    if (options === void 0) { options = {}; }\n    var _a = options.locale, locale$1 = _a === void 0 ? locale.enUS : _a, required = options.required, _b = options.format, format = _b === void 0 ? 'PP' : _b, defaultSelected = options.defaultSelected, _c = options.today, today = _c === void 0 ? new Date() : _c;\n    var _d = parseFromToProps(options), fromDate = _d.fromDate, toDate = _d.toDate;\n    // Shortcut to the DateFns functions\n    var parseValue = function (value) { return dateFns.parse(value, format, today, { locale: locale$1 }); };\n    // Initialize states\n    var _e = react.useState(defaultSelected !== null && defaultSelected !== void 0 ? defaultSelected : today), month = _e[0], setMonth = _e[1];\n    var _f = react.useState(defaultSelected), selectedDay = _f[0], setSelectedDay = _f[1];\n    var defaultInputValue = defaultSelected\n        ? dateFns.format(defaultSelected, format, { locale: locale$1 })\n        : '';\n    var _g = react.useState(defaultInputValue), inputValue = _g[0], setInputValue = _g[1];\n    var reset = function () {\n        setSelectedDay(defaultSelected);\n        setMonth(defaultSelected !== null && defaultSelected !== void 0 ? defaultSelected : today);\n        setInputValue(defaultInputValue !== null && defaultInputValue !== void 0 ? defaultInputValue : '');\n    };\n    var setSelected = function (date) {\n        setSelectedDay(date);\n        setMonth(date !== null && date !== void 0 ? date : today);\n        setInputValue(date ? dateFns.format(date, format, { locale: locale$1 }) : '');\n    };\n    var handleDayClick = function (day, _a) {\n        var selected = _a.selected;\n        if (!required && selected) {\n            setSelectedDay(undefined);\n            setInputValue('');\n            return;\n        }\n        setSelectedDay(day);\n        setInputValue(day ? dateFns.format(day, format, { locale: locale$1 }) : '');\n    };\n    var handleMonthChange = function (month) {\n        setMonth(month);\n    };\n    // When changing the input field, save its value in state and check if the\n    // string is a valid date. If it is a valid day, set it as selected and update\n    // the calendar’s month.\n    var handleChange = function (e) {\n        setInputValue(e.target.value);\n        var day = parseValue(e.target.value);\n        var isBefore = fromDate && dateFns.differenceInCalendarDays(fromDate, day) > 0;\n        var isAfter = toDate && dateFns.differenceInCalendarDays(day, toDate) > 0;\n        if (!isValidDate(day) || isBefore || isAfter) {\n            setSelectedDay(undefined);\n            return;\n        }\n        setSelectedDay(day);\n        setMonth(day);\n    };\n    // Special case for _required_ fields: on blur, if the value of the input is not\n    // a valid date, reset the calendar and the input value.\n    var handleBlur = function (e) {\n        var day = parseValue(e.target.value);\n        if (!isValidDate(day)) {\n            reset();\n        }\n    };\n    // When focusing, make sure DayPicker visualizes the month of the date in the\n    // input field.\n    var handleFocus = function (e) {\n        if (!e.target.value) {\n            reset();\n            return;\n        }\n        var day = parseValue(e.target.value);\n        if (isValidDate(day)) {\n            setMonth(day);\n        }\n    };\n    var dayPickerProps = {\n        month: month,\n        onDayClick: handleDayClick,\n        onMonthChange: handleMonthChange,\n        selected: selectedDay,\n        locale: locale$1,\n        fromDate: fromDate,\n        toDate: toDate,\n        today: today\n    };\n    var inputProps = {\n        onBlur: handleBlur,\n        onChange: handleChange,\n        onFocus: handleFocus,\n        value: inputValue,\n        placeholder: dateFns.format(new Date(), format, { locale: locale$1 })\n    };\n    return { dayPickerProps: dayPickerProps, inputProps: inputProps, reset: reset, setSelected: setSelected };\n}\n\n/** Returns true when the props are of type {@link DayPickerDefaultProps}. */\nfunction isDayPickerDefault(props) {\n    return props.mode === undefined || props.mode === 'default';\n}\n\nexports.Button = Button;\nexports.Caption = Caption;\nexports.CaptionDropdowns = CaptionDropdowns;\nexports.CaptionLabel = CaptionLabel;\nexports.CaptionNavigation = CaptionNavigation;\nexports.Day = Day;\nexports.DayContent = DayContent;\nexports.DayPicker = DayPicker;\nexports.DayPickerContext = DayPickerContext;\nexports.DayPickerProvider = DayPickerProvider;\nexports.Dropdown = Dropdown;\nexports.FocusContext = FocusContext;\nexports.FocusProvider = FocusProvider;\nexports.Footer = Footer;\nexports.Head = Head;\nexports.HeadRow = HeadRow;\nexports.IconDropdown = IconDropdown;\nexports.IconLeft = IconLeft;\nexports.IconRight = IconRight;\nexports.Months = Months;\nexports.NavigationContext = NavigationContext;\nexports.NavigationProvider = NavigationProvider;\nexports.RootProvider = RootProvider;\nexports.Row = Row;\nexports.SelectMultipleContext = SelectMultipleContext;\nexports.SelectMultipleProvider = SelectMultipleProvider;\nexports.SelectMultipleProviderInternal = SelectMultipleProviderInternal;\nexports.SelectRangeContext = SelectRangeContext;\nexports.SelectRangeProvider = SelectRangeProvider;\nexports.SelectRangeProviderInternal = SelectRangeProviderInternal;\nexports.SelectSingleContext = SelectSingleContext;\nexports.SelectSingleProvider = SelectSingleProvider;\nexports.SelectSingleProviderInternal = SelectSingleProviderInternal;\nexports.WeekNumber = WeekNumber;\nexports.addToRange = addToRange;\nexports.isDateAfterType = isDateAfterType;\nexports.isDateBeforeType = isDateBeforeType;\nexports.isDateInterval = isDateInterval;\nexports.isDateRange = isDateRange;\nexports.isDayOfWeekType = isDayOfWeekType;\nexports.isDayPickerDefault = isDayPickerDefault;\nexports.isDayPickerMultiple = isDayPickerMultiple;\nexports.isDayPickerRange = isDayPickerRange;\nexports.isDayPickerSingle = isDayPickerSingle;\nexports.isMatch = isMatch;\nexports.useActiveModifiers = useActiveModifiers;\nexports.useDayPicker = useDayPicker;\nexports.useDayRender = useDayRender;\nexports.useFocusContext = useFocusContext;\nexports.useInput = useInput;\nexports.useNavigation = useNavigation;\nexports.useSelectMultiple = useSelectMultiple;\nexports.useSelectRange = useSelectRange;\nexports.useSelectSingle = useSelectSingle;\n//# sourceMappingURL=index.js.map\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///(ssr)/./node_modules/react-day-picker/dist/index.js\n");

/***/ })

};
;