# MEIWA TASKS - Aplicación de Gestión de Tareas

**Desarrollado por:** LUIS ADRIAN ESPARZA MONTOYA 


## Características Principales

### 🔐 Autenticación y Seguridad
- Registro e inicio de sesión con Supabase Auth
- Validación de formularios en tiempo real
- Protección de rutas privadas
- Gestión segura de sesiones

### 📝 Gestión de Tareas
- Crear, editar y eliminar tareas
- Marcar tareas como completadas
- Categorización por proyectos
- Niveles de prioridad (Baja, Media, Alta)
- Fechas de vencimiento
- Búsqueda y filtrado avanzado

### 📊 Dashboard y Estadísticas
- Vista general de tareas
- Estadísticas en tiempo real
- Gráficos de progreso
- Tareas pendientes y completadas
- Identificación de tareas atrasadas

### 🎨 Diseño y UX
- Diseño responsive para todos los dispositivos
- Interfaz moderna con Tailwind CSS
- Componentes reutilizables con shadcn/ui
- Animaciones suaves y micro-interacciones
- Tema claro con colores profesionales

## Tecnologías Utilizadas

### Frontend
- **Next.js 13** - Framework de React con App Router
- **React 18** - Biblioteca de JavaScript para UI
- **TypeScript** - Tipado estático
- **Tailwind CSS** - Framework de estilos
- **shadcn/ui** - Sistema de componentes

### Backend y Base de Datos
- **Supabase** - Backend como servicio (BaaS)
- **PostgreSQL** - Base de datos relacional
- **Row Level Security (RLS)** - Seguridad a nivel de fila

### Herramientas de Desarrollo
- **ESLint** - Linting de código
- **Prettier** - Formateo de código
- **Lucide React** - Iconos

## Estructura del Proyecto

```
taskflow-pro/
├── app/                    # App Router de Next.js
│   ├── dashboard/         # Páginas del dashboard
│   ├── globals.css        # Estilos globales
│   ├── layout.tsx         # Layout principal
│   └── page.tsx           # Página de inicio
├── components/            # Componentes reutilizables
│   ├── auth/             # Componentes de autenticación
│   ├── dashboard/        # Componentes del dashboard
│   ├── tasks/            # Componentes de tareas
│   └── ui/               # Componentes de UI (shadcn/ui)
├── lib/                  # Utilidades y configuración
│   ├── supabase.ts       # Cliente de Supabase
│   └── utils.ts          # Funciones de utilidad
└── hooks/                # Hooks personalizados
```

## Configuración de la Base de Datos

### Tablas Principales

1. **profiles** - Perfiles de usuario
2. **tasks** - Tareas de los usuarios
3. **categories** - Categorías de tareas

### Políticas de Seguridad (RLS)

- Los usuarios solo pueden ver y modificar sus propias tareas
- Las categorías son específicas por usuario
- Los perfiles están protegidos por autenticación

## Instalación y Configuración

### Prerrequisitos
- Node.js 18+ 
- Una cuenta en Supabase
- Git

### Pasos de Instalación

1. **Clonar el repositorio**
```bash
git clone <https://github.com/Jotalora1/TaskFlow-Pro.git>
cd taskflow-pro
```

2. **Instalar dependencias**
```bash
npm install
```

3. **Configurar variables de entorno**
```bash
cp .env.local.example .env.local
```

Editar `.env.local` con tus credenciales de Supabase:
```env
NEXT_PUBLIC_SUPABASE_URL=tu_url_de_supabase
NEXT_PUBLIC_SUPABASE_ANON_KEY=tu_clave_anonima_de_supabase
```

4. **Ejecutar migraciones de base de datos**
- Crear las tablas en Supabase usando el SQL proporcionado
- Configurar las políticas RLS

5. **Iniciar el servidor de desarrollo**
```bash
npm run dev
```

## Funcionalidades Implementadas

### Principales
- [x] Conexión a base de datos (Supabase)
- [x] Autenticación de usuarios
- [x] CRUD completo de tareas
- [x] Diseño responsive
- [x] Filtrado y búsqueda
- [x] Gestión de categorías
- [x] Dashboard con estadísticas
- [x] Validación de formularios
- [x] Manejo de errores
- [x] Notificaciones toast

### 🚀 Características Adicionales
- [x] Prioridades de tareas
- [x] Fechas de vencimiento
- [x] Tareas atrasadas
- [x] Sidebar navegable
- [x] Animaciones suaves
- [x] Indicadores de carga

## Arquitectura y Patrones

### Patrones Implementados
- **Component-based Architecture** - Componentes reutilizables
- **Custom Hooks** - Lógica reutilizable
- **Separation of Concerns** - Separación clara de responsabilidades
- **Error Boundaries** - Manejo de errores
- **Responsive Design** - Diseño adaptable

## Contribuciones y Extensiones

### Posibles Mejoras
- [ ] Notificaciones push
- [ ] Colaboración en tareas
- [ ] Etiquetas personalizadas
- [ ] Exportación de datos
- [ ] Modo oscuro
- [ ] Aplicación móvil

### Tecnologías Adicionales
- **React Query** - Gestión de estado del servidor
- **Framer Motion** - Animaciones avanzadas
- **React Hook Form** - Formularios optimizados
- **Zod** - Validación de esquemas

MEIWAMOLD MEXICO S.A. DE C.V.
LUIS ADRIAN ESPARZA MONTOYA