"use client";

import Link from "next/link";
import { ArrowUpRight, ClipboardList, RefreshCcw } from "lucide-react";
import { SGIDashboardLayout } from "@/components/dashboard/sgi-dashboard-layout";

const improvementOptions = [
  {
    id: "no-conformidad-accion-correctiva",
    title: "No Conformidad y Acción Correctiva",
    description: "Registro, análisis y seguimiento de acciones correctivas.",
    href: "/meiwa-core/meiwa-sgi/improvement/nonconformity-corrective-action",
    icon: ClipboardList,
    badge: "Acciones correctivas",
  },
  {
    id: "mejora-continua",
    title: "Mejora Continua",
    description: "Iniciativas, resultados y evolución de la mejora continua.",
    href: "/meiwa-core/meiwa-sgi/improvement/continuous-improvement",
    icon: RefreshCcw,
    badge: "Evolución y resultados",
  },
];

export default function ImprovementPage() {
  return (
    <SGIDashboardLayout>
      <div className="min-h-screen space-y-10 bg-gradient-to-br from-slate-50 via-white to-emerald-50 pb-20">
        <section className="relative overflow-hidden rounded-3xl border border-emerald-100 bg-white px-6 py-10 shadow-sm sm:px-10">
          <div className="absolute inset-0 bg-gradient-to-r from-emerald-500/10 to-lime-400/10" />
          <div className="relative space-y-4">
            <p className="text-xs font-semibold uppercase tracking-[0.5em] text-emerald-600">
              Sistema de Gestión Integral
            </p>
            <h1 className="text-3xl font-bold text-gray-900 sm:text-4xl">Mejora continua</h1>
            <p className="max-w-3xl text-base text-gray-600 sm:text-lg">
              Selecciona el módulo para gestionar la mejora continua y las acciones correctivas.
            </p>
          </div>
        </section>

        <section className="grid gap-6 lg:grid-cols-2">
          {improvementOptions.map((option) => {
            const Icon = option.icon;

            return (
              <Link
                key={option.id}
                href={option.href}
                className="group flex h-full flex-col justify-between rounded-3xl border border-emerald-100 bg-white p-6 shadow-sm transition duration-200 hover:-translate-y-1 hover:border-emerald-300 hover:shadow-lg"
              >
                <div className="flex items-start justify-between gap-4">
                  <div className="rounded-2xl bg-emerald-50 p-3">
                    <Icon className="h-6 w-6 text-emerald-600" />
                  </div>
                  <span className="rounded-full bg-emerald-100 px-3 py-1 text-xs font-semibold uppercase tracking-wide text-emerald-700">
                    {option.badge}
                  </span>
                </div>
                <div className="mt-6 space-y-3">
                  <h2 className="text-xl font-semibold text-gray-900">{option.title}</h2>
                  <p className="text-sm text-gray-600">{option.description}</p>
                </div>
                <div className="mt-6 flex items-center gap-2 text-sm font-semibold text-emerald-600">
                  <span>Ir a la sección</span>
                  <ArrowUpRight className="h-4 w-4 transition-transform duration-200 group-hover:translate-x-1" />
                </div>
              </Link>
            );
          })}
        </section>
      </div>
    </SGIDashboardLayout>
  );
}