"use client";

import Link from "next/link";
import { useState } from "react";
import { Award, Leaf, ShieldCheck } from "lucide-react";
import { SGIDashboardLayout } from "@/components/dashboard/sgi-dashboard-layout";

const processMaps = {
  "medio-ambiente": [
    {
      title: "Procesos estratégicos",
      description: "Definen la dirección y prioridades del sistema de gestión integral.",
      accent: "from-emerald-500 to-sky-500",
      items: [
        {
          number: "1",
          label: "Contexto de la organización",
          href: "/meiwa-core/meiwa-sgi/context",
        },
        {
          number: "2",
          label: "Liderazgo",
          href: "/meiwa-core/meiwa-sgi/leadership",
        },
        {
          number: "3",
          label: "Planificación",
          href: "/meiwa-core/meiwa-sgi/planning",
        },
        {
          number: "4",
          label: "Mejora",
          href: "/meiwa-core/meiwa-sgi/improvement",
        },
      ],
    },
    {
      title: "Procesos de operaciones",
      description: "Gestionan la operación y el desempeño ambiental diario.",
      accent: "from-sky-500 to-indigo-500",
      items: [
        {
          number: "5",
          label: "Servicios externalizados",
          href: "/meiwa-core/meiwa-sgi/operation/external",
        },
        {
          number: "6",
          label: "Residuos Solidos Urbanos",
          href: "/meiwa-core/meiwa-sgi/operation/rsu",
        },
        {
          number: "7",
          label: "Residuos de Manejo Especial",
          href: "/meiwa-core/meiwa-sgi/operation/rme",
        },           
        {
          number: "8",
          label: "Calidad",
          href: "/meiwa-core/meiwa-sgi/operation/quality",
        },
        {
          number: "9",
          label: "Energía",
          href: "/meiwa-core/meiwa-sgi/operation/energy",
        },
        {
          number: "10",
          label: "Agua",
          href: "/meiwa-core/meiwa-sgi/operation/water",
        },
        {
          number: "11",
          label: "Residuos peligrosos",
          href: "/meiwa-core/meiwa-sgi/operation/rp",
        },
        {
          number: "12",
          label: "Combustibles",
          href: "/meiwa-core/meiwa-sgi/operation/fuels",
        },
      ],
    },
    {
      title: "Procesos de soporte",
      description: "Acompañan el cumplimiento y la mejora del sistema.",
      accent: "from-indigo-500 to-slate-500",
      items: [
        {
          number: "13",
          label: "Soporte",
          href: "/meiwa-core/meiwa-sgi/support",
        },
        {
          number: "14",
          label: "Evaluación de desempeño",
          href: "/meiwa-core/meiwa-sgi/evaluation",
        },
      ],
    },
  ],
  calidad: [],
  seguridad: [],
};

const mapOptions = [
  {
    id: "medio-ambiente",
    title: "Medio Ambiente",
    description: "Mapa ambiental activo en el SGI.",
    icon: Leaf,    
  },
  {
    id: "calidad",
    title: "Calidad",
    description: "Mapa de procesos de calidad.",
    icon: Award,    
  },
  {
    id: "seguridad",
    title: "Seguridad",
    description: "Mapa de procesos de seguridad.",
    icon: ShieldCheck,    
  },
] as const;

export default function OperationPage() {
  const [selectedMap, setSelectedMap] = useState<(typeof mapOptions)[number]["id"]>(
    "medio-ambiente",
  );
  const sections = processMaps[selectedMap];

  return (
    <SGIDashboardLayout>
      <div className="min-h-screen space-y-10 bg-gradient-to-br from-slate-50 via-white to-emerald-50">
        <section className="relative overflow-hidden rounded-3xl border border-emerald-100 bg-white px-6 py-10 shadow-sm sm:px-10">
          <div className="absolute inset-0 bg-gradient-to-r from-emerald-500/10 to-sky-500/10" />
          <div className="relative space-y-4">
            <p className="text-xs font-semibold uppercase tracking-[0.5em] text-emerald-600">
              Sistema de Gestión Integral
            </p>
            <h1 className="text-3xl font-bold text-gray-900 sm:text-4xl">Mapa de procesos</h1>
            <p className="max-w-3xl text-base text-gray-600 sm:text-lg">
              Selecciona una sección para acceder a los contenidos del SGI. Cada bloque representa
              un proceso clave y dirige a la página correspondiente.
            </p>
          </div>       
        </section>

          <div className="mt-6 flex flex-wrap gap-3">
            {mapOptions.map((option) => {
              const isActive = selectedMap === option.id;
              const Icon = option.icon;              
              return (
                <button
                  key={option.id}
                  type="button"
                  onClick={() => setSelectedMap(option.id)}
                  className={`flex items-center gap-2 rounded-full border px-4 py-2 text-sm font-semibold transition-all duration-200 ${
                    isActive
                      ? "border-transparent bg-gradient-to-r from-emerald-500 to-lime-500 text-white shadow-lg"
                      : "border-gray-200 bg-white text-gray-600 hover:border-emerald-200 hover:text-emerald-700"
                  }`}
                >
                  <Icon className={`h-4 w-4 ${isActive ? "text-white" : "text-emerald-500"}`} />
                  {option.title}
                </button>
              );
            })}
          </div>

        <div className="grid gap-6 lg:grid-cols-[140px_1fr_140px]">
          <div className="hidden lg:flex items-center justify-center">
            <div className="rounded-3xl border-4 border-emerald-600 bg-white px-4 py-8 text-center text-sm font-semibold uppercase tracking-[0.3em] text-gray-700">
              Requisitos
            </div>
          </div>

          <div className="space-y-8">
            {sections.length ? (
              sections.map((section) => (
                <section
                  key={section.title}
                  className="rounded-3xl border border-emerald-100 bg-white p-6 shadow-sm sm:p-8"
                >
                  <div className="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
                    <div>
                      <h2 className="text-xl font-semibold text-gray-900 sm:text-2xl">
                        {section.title}
                      </h2>
                      <p className="text-sm text-gray-600">{section.description}</p>
                    </div>
                    <div
                      className={`h-1 w-full rounded-full bg-gradient-to-r ${section.accent} sm:h-1 sm:w-32`}
                    />
                  </div>

                  <div className="mt-6 grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                    {section.items.map((item) => (
                      <Link
                        key={item.number}
                        href={item.href}
                        className="group flex items-center gap-4 rounded-2xl border border-slate-200 bg-white px-4 py-4 shadow-sm transition duration-200 hover:-translate-y-0.5 hover:border-emerald-400 hover:shadow-md"
                      >
                        <span className="flex h-10 w-10 items-center justify-center rounded-full border-2 border-emerald-400 bg-emerald-50 text-sm font-semibold text-emerald-700">
                          {item.number}
                        </span>
                        <span className="text-sm font-semibold text-gray-800 group-hover:text-emerald-700">
                          {item.label}
                        </span>
                      </Link>
                    ))}
                  </div>
                </section>
              ))
            ) : (
              <section className="rounded-3xl border border-slate-200 bg-white p-10 text-center shadow-sm">
                <p className="text-sm font-semibold uppercase tracking-[0.3em] text-slate-400">
                  Próximamente
                </p>
                <h2 className="mt-3 text-2xl font-semibold text-gray-900">
                  Mapa de procesos en preparación
                </h2>
                <p className="mt-2 text-sm text-gray-600">
                  Estamos trabajando para habilitar el mapa de procesos de{" "}
                  {selectedMap === "calidad" ? "calidad" : "seguridad"}.
                </p>
              </section>
            )}
          </div>

          <div className="hidden lg:flex items-center justify-center">
            <div className="rounded-3xl border-4 border-emerald-600 bg-white px-4 py-8 text-center text-sm font-semibold uppercase tracking-[0.3em] text-gray-700">
              Producto/ Servicio
            </div>
          </div>
        </div>
      </div>
    </SGIDashboardLayout>
  );
}