"use client";

import { useEffect, useState } from "react";
import { useRouter, useSearchParams } from "next/navigation";
import { toast } from "sonner";

import { AwarenessModuleForm } from "@/components/awareness/awareness-module-form";
import { SGIDashboardLayout } from "@/components/dashboard/sgi-dashboard-layout";
import { Card, CardContent } from "@/components/ui/card";
import { supabase } from "@/lib/supabase";

const allowedManagers = new Set([
  "ehs.mexico@meiwa.com.mx",
  "admin2.mexico@meiwa.com.mx",
  "auxiliar.ehs@meiwa.com.mx",
]);

export default function AwarenessModuleEditPage() {
  const router = useRouter();
  const searchParams = useSearchParams();
  const moduleId = searchParams.get("moduleId");
  const [checkingAccess, setCheckingAccess] = useState(true);
  const [authorized, setAuthorized] = useState(false);

  useEffect(() => {
    const verifyAccess = async () => {
      const { data: { session } } = await supabase.auth.getSession();

      if (!session?.user) {
        router.push("/");
        return;
      }

      const canManage = allowedManagers.has(session.user.email ?? "");
      if (!canManage) {
        toast.error("No tienes permisos para editar módulos.");
        router.push("/meiwa-core/meiwa-sgi/support/awareness");
        return;
      }

      if (!moduleId) {
        toast.error("Selecciona un módulo válido para editar.");
        setAuthorized(false);
        setCheckingAccess(false);
        return;
      }

      setAuthorized(true);
      setCheckingAccess(false);
    };

    void verifyAccess();
  }, [moduleId, router]);

  if (checkingAccess) {
    return (
      <SGIDashboardLayout>
        <Card>
          <CardContent className="py-10 text-center text-sm text-muted-foreground">
            Verificando permisos...
          </CardContent>
        </Card>
      </SGIDashboardLayout>
    );
  }

  if (!authorized) {
    return (
      <SGIDashboardLayout>
        <Card>
          <CardContent className="py-10 text-center text-sm text-muted-foreground">
            No se encontró el módulo solicitado.
          </CardContent>
        </Card>
      </SGIDashboardLayout>
    );
  }

  return (
    <SGIDashboardLayout>
      <div className="space-y-6">
        <div>
          <p className="text-sm font-semibold uppercase tracking-[0.2em] text-muted-foreground">
            Awareness · Administración
          </p>
          <h1 className="text-2xl font-bold text-gray-900">Editar módulo</h1>
        </div>
        <AwarenessModuleForm
          mode="edit"
          moduleId={moduleId ?? undefined}
          onSuccess={() => router.push("/meiwa-core/meiwa-sgi/support/awareness")}
        />
      </div>
    </SGIDashboardLayout>
  );
}