"use client";

import { Button } from '@/components/ui/button';
import { CheckCircle, Circle, Clock } from 'lucide-react';

interface TaskFilterProps {
  filter: 'all' | 'completed' | 'pending';
  onFilterChange: (filter: 'all' | 'completed' | 'pending') => void;
}

export function TaskFilter({ filter, onFilterChange }: TaskFilterProps) {
  const filters = [
    { value: 'all', label: 'Todas', icon: Circle },
    { value: 'pending', label: 'Pendientes', icon: Clock },
    { value: 'completed', label: 'Completadas', icon: CheckCircle },
  ] as const;

  return (
    <div className="flex flex-wrap gap-2">
      {filters.map(({ value, label, icon: Icon }) => (
        <Button
          key={value}
          variant={filter === value ? 'default' : 'outline'}
          size="sm"
          onClick={() => onFilterChange(value)}
          className="flex items-center gap-2"
        >
          <Icon className="h-4 w-4" />
          {label}
        </Button>
      ))}
    </div>
  );
}