"use client";

import { useCallback, useEffect, useMemo, useState } from "react";
import { supabase } from "@/lib/supabase";

export type NotificationType = "assignment" | "team" | "deadline" | "metric";

export type NotificationItem = {
  id: string;
  type: NotificationType;
  title: string;
  description: string;
  date: string;
  unread: boolean;
  action?: { label: string; href: string };
  meta?: {
    due?: string;
    priority?: "Alta" | "Media" | "Baja";
    value?: string;
  };
};
