import { supabase } from "@/lib/supabase";

export type PointsProfile = {
  id: string;
  full_name: string | null;
  email: string | null;
  role?: string | null;
  is_admin?: boolean | null;
};

const adminEmails = new Set(["ehs.mexico@meiwa.com.mx", "laem23.01@gmail.com","recursoshumanos@meiwa.com.mx"]);

export const isPointsAdminEmail = (email: string | null | undefined) => {
  if (!email) return false;
  return adminEmails.has(email.toLowerCase());
};

export const isPointsAdmin = (profile: PointsProfile | null) => {
  return isPointsAdminEmail(profile?.email);
};

export const fetchPointsProfile = async (userId: string) => {
  return supabase
    .from("profiles")
    .select("id, full_name, email, role, is_admin")
    .eq("id", userId)
    .single();
};