import { addDays, addMonths, addWeeks, addYears, isValid } from 'date-fns';

export type RecurrencePattern = 'daily' | 'weekly' | 'monthly' | 'yearly';

export function calculateNextDueDate(
  currentDueDate: string | Date | null,
  recurrencePattern: RecurrencePattern | null,
  recurrenceInterval = 1
): string | null {
  if (!recurrencePattern) return null;

  const baseDate = currentDueDate ? new Date(currentDueDate) : new Date();
  if (!isValid(baseDate)) return null;

  const interval = Math.max(1, recurrenceInterval);

  const nextDate = {
    daily: addDays(baseDate, interval),
    weekly: addWeeks(baseDate, interval),
    monthly: addMonths(baseDate, interval),
    yearly: addYears(baseDate, interval)
  }[recurrencePattern];

  if (!isValid(nextDate)) return null;

  return nextDate.toISOString().split('T')[0];
}
