import {
  ClipboardCheck,
  ClipboardCopyIcon,
  Crown,
  Globe,
  Home,
  LifeBuoy,
  SearchCheck,
  Settings,
  TrendingUp,
} from "lucide-react";

export const sgiNavigation = [
  { name: "Dashboard", href: "/meiwa-core/meiwa-sgi", icon: Home },
  { name: "Contexto", href: "/meiwa-core/meiwa-sgi/context", icon: Globe },
  { name: "Liderazgo", href: "/meiwa-core/meiwa-sgi/leadership", icon: Crown },
  { name: "Planeación", href: "/meiwa-core/meiwa-sgi/planning", icon: ClipboardCheck },
  { name: "Soporte", href: "/meiwa-core/meiwa-sgi/support", icon: LifeBuoy },
  { name: "Operación", href: "/meiwa-core/meiwa-sgi/operation", icon: Settings },
  { name: "Evaluación", href: "/meiwa-core/meiwa-sgi/evaluation", icon: SearchCheck },
  { name: "Mejora", href: "/meiwa-core/meiwa-sgi/improvement", icon: TrendingUp },
];

export const sgiNavigationPaths = sgiNavigation.map((item) => item.href);

const sgiAdminSubpages = [
  { name: "Operación - RP", href: "/meiwa-core/meiwa-sgi/operation/rp" },
  { name: "Operación - RME", href: "/meiwa-core/meiwa-sgi/operation/rme" },
  { name: "Operación - RSU", href: "/meiwa-core/meiwa-sgi/operation/rsu" },
  { name: "Operación - Calidad", href: "/meiwa-core/meiwa-sgi/operation/quality" },
  { name: "Operación - Energía", href: "/meiwa-core/meiwa-sgi/operation/energy" },
  { name: "Operación - Agua", href: "/meiwa-core/meiwa-sgi/operation/water" },
  { name: "Operación - Servicios Externalizados", href: "/meiwa-core/meiwa-sgi/operation/external" },
  { name: "Planeación - Aspectos e Impactos", href: "/meiwa-core/meiwa-sgi/planning/aspects" },
  { name: "Planeación - Objetivos", href: "/meiwa-core/meiwa-sgi/planning/objectives" },
  { name: "Soporte - Competencia", href: "/meiwa-core/meiwa-sgi/support/competence" },
  { name: "Soporte - Comunicación", href: "/meiwa-core/meiwa-sgi/support/communication" },
  { name: "Soporte - Documentación", href: "/meiwa-core/meiwa-sgi/support/documentation" },
  { name: "Políticas", href: "/meiwa-core/meiwa-sgi/policies" },
  { name: "Certificate", href: "/meiwa-core/meiwa-sgi/certificate" },
  { name: "Perfil", href: "/meiwa-core/meiwa-sgi/profile" },
];

export const sgiAdminPagePaths = [...sgiNavigation, ...sgiAdminSubpages].map((item) => item.href);