export const getQuarterFromDate = (date: Date): number => {
  const month = date.getMonth();
  return Math.floor(month / 3) + 1;
};

export const getQuarterLabel = (year: number, quarter: number): string => `Q${quarter} ${year}`;

export const calculateEnvironmentalScore = (values: {
  envCert: boolean;
  envRse: boolean;
  envPolicy: boolean;
}): number => {
  const count = [values.envCert, values.envRse, values.envPolicy].filter(Boolean).length;

  if (count === 3) return 5;
  if (count === 2) return 3;
  if (count === 1) return 2;
  return 1;
};

export const calculateFinalScore = (values: {
  envScore: number;
  techSpecScore: number;
  deliveryScore: number;
  costScore: number;
  paymentTermsScore: number;
  qualityCertsScore: number;
}): number => {
  const total =
    values.envScore * 0.1 +
    values.techSpecScore * 0.25 +
    values.deliveryScore * 0.25 +
    values.costScore * 0.2 +
    values.paymentTermsScore * 0.1 +
    values.qualityCertsScore * 0.1;

  return Number(total.toFixed(2));
};

export const resolveStatus = (score: number): 'APROBADO' | 'REPROBADO' =>
  score >= 3.6 ? 'APROBADO' : 'REPROBADO';

export const addMonths = (date: Date, months: number): Date => {
  const next = new Date(date);
  next.setMonth(next.getMonth() + months);
  return next;
};