/// <reference types="react/experimental" />
import React from 'react';
export type ErrorComponent = React.ComponentType<{
    error: Error;
    reset: () => void;
}>;
export interface ErrorBoundaryProps {
    children?: React.ReactNode;
    errorComponent: ErrorComponent;
    errorStyles?: React.ReactNode | undefined;
}
interface ErrorBoundaryHandlerProps extends ErrorBoundaryProps {
    pathname: string;
}
interface ErrorBoundaryHandlerState {
    error: Error | null;
    previousPathname: string;
}
export declare class ErrorBoundaryHandler extends React.Component<ErrorBoundaryHandlerProps, ErrorBoundaryHandlerState> {
    constructor(props: ErrorBoundaryHandlerProps);
    static getDerivedStateFromError(error: Error): {
        error: Error;
    };
    static getDerivedStateFromProps(props: ErrorBoundaryHandlerProps, state: ErrorBoundaryHandlerState): ErrorBoundaryHandlerState | null;
    reset: () => void;
    render(): string | number | boolean | React.ReactFragment | React.PromiseLikeOfReactNode | React.JSX.Element | null | undefined;
}
export declare function GlobalError({ error }: {
    error: any;
}): React.JSX.Element;
export default GlobalError;
/**
 * Handles errors through `getDerivedStateFromError`.
 * Renders the provided error component and provides a way to `reset` the error boundary state.
 */
/**
 * Renders error boundary with the provided "errorComponent" property as the fallback.
 * If no "errorComponent" property is provided it renders the children without an error boundary.
 */
export declare function ErrorBoundary({ errorComponent, errorStyles, children, }: ErrorBoundaryProps & {
    children: React.ReactNode;
}): JSX.Element;
