const fs = require('fs');
const path = require('path');

const projectRoot = path.resolve(__dirname, '..');
const patchRoot = path.join(projectRoot, 'patches', 'recharts');
const targets = [
  'es6/cartesian/XAxis.js',
  'es6/cartesian/YAxis.js',
  'es6/cartesian/ZAxis.js',
  'es6/cartesian/Scatter.js',
  'es6/chart/generateCategoricalChart.js',
  'lib/cartesian/XAxis.js',
  'lib/cartesian/YAxis.js',
  'lib/cartesian/ZAxis.js',
  'lib/cartesian/Scatter.js',
  'lib/chart/generateCategoricalChart.js'
];

targets.forEach((relativePath) => {
  const source = path.join(patchRoot, relativePath);
  const destination = path.join(projectRoot, 'node_modules', 'recharts', relativePath);

  if (!fs.existsSync(source)) {
    console.warn(`[patch-recharts] Skipping missing patch source: ${relativePath}`);
    return;
  }

  if (!fs.existsSync(destination)) {
    console.warn(`[patch-recharts] Skipping missing destination: ${relativePath}`);
    return;
  }

  fs.mkdirSync(path.dirname(destination), { recursive: true });
  fs.copyFileSync(source, destination);
  console.info(`[patch-recharts] Patched ${relativePath}`);
});