-- Ensure profiles table includes email data and keep trigger up to date
ALTER TABLE profiles
  ADD COLUMN IF NOT EXISTS email TEXT;

-- Refresh handle_new_user trigger function to store email
CREATE OR REPLACE FUNCTION handle_new_user()
RETURNS TRIGGER AS $$
BEGIN
  INSERT INTO profiles (id, full_name, email, avatar_url)
  VALUES (
    NEW.id,
    NEW.raw_user_meta_data ->> 'full_name',
    NEW.email,
    NEW.raw_user_meta_data ->> 'avatar_url'
  )
  ON CONFLICT (id) DO UPDATE
    SET full_name = EXCLUDED.full_name,
        email = EXCLUDED.email,
        avatar_url = EXCLUDED.avatar_url;

  -- Insert default categories
  INSERT INTO categories (name, color, user_id) VALUES
    ('Trabajo', '#3B82F6', NEW.id),
    ('Personal', '#10B981', NEW.id),
    ('Estudios', '#F59E0B', NEW.id),
    ('Hogar', '#EF4444', NEW.id)
  ON CONFLICT DO NOTHING;

  RETURN NEW;
END;
$$ LANGUAGE plpgsql SECURITY DEFINER;


