-- Align team_tasks schema with application expectations
-- Add recurrence fields (pattern, interval, end date)
alter table if exists team_tasks
  add column if not exists recurrence_pattern text,
  add column if not exists recurrence_interval integer,
  add column if not exists recurrence_end_date timestamptz;

-- Ensure recurrence interval is positive when a recurrence pattern exists
do $$
begin
  if not exists (
    select 1 from pg_constraint
    where conname = 'team_tasks_recurrence_interval_positive'
      and conrelid = 'team_tasks'::regclass
  ) then
    alter table if exists team_tasks
      add constraint team_tasks_recurrence_interval_positive check (
        recurrence_pattern is null or recurrence_interval > 0
      );
  end if;
end $$;

-- Refresh foreign key relationships to profiles for embedding
alter table if exists team_tasks drop constraint if exists team_tasks_member_id_fkey;
alter table if exists team_tasks drop constraint if exists team_tasks_assigned_by_fkey;

alter table if exists team_tasks
  add constraint team_tasks_member_id_fkey
  foreign key (member_id) references profiles(id) on delete cascade;

alter table if exists team_tasks
  add constraint team_tasks_assigned_by_fkey
  foreign key (assigned_by) references profiles(id) on delete cascade;
