set search_path = public, extensions, pg_temp;

-- Add team reference to team_tasks for clarity in assignments
alter table if exists team_tasks
  add column if not exists team_id uuid references teams(id) on delete cascade;

-- Backfill team_id for existing tasks using the owner/member pairing
with owner_member_team as (
  select distinct on (member_id, owner_id) member_id, owner_id, team_id
  from team_members
  where team_id is not null
  order by member_id, owner_id, created_at asc
)
update team_tasks tt
set team_id = omt.team_id
from owner_member_team omt
where tt.team_id is null
  and tt.member_id = omt.member_id
  and tt.assigned_by = omt.owner_id;

-- Ensure new assignments are tied to an owner's team
do $$
begin
  if exists (
    select 1 from pg_policies where schemaname = 'public' and tablename = 'team_tasks' and policyname = 'Owners can assign tasks'
  ) then
    drop policy "Owners can assign tasks" on team_tasks;
  end if;

  create policy "Owners can assign tasks" on team_tasks
    for insert
    to authenticated
    with check (
      assigned_by = auth.uid()
      and team_id in (select id from teams where owner_id = auth.uid())
    );
end;
$$;

-- Index for filtering tasks by team
create index if not exists idx_team_tasks_team on team_tasks(team_id);